/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.IosManagedAppProtection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionRequestBuilder;
import com.microsoft.graph.requests.generated.BaseIosManagedAppProtectionCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseIosManagedAppProtectionCollectionRequest;
import java.util.List;

public class BaseIosManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<BaseIosManagedAppProtectionCollectionResponse, IIosManagedAppProtectionCollectionPage>
implements IBaseIosManagedAppProtectionCollectionRequest {
    public BaseIosManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseIosManagedAppProtectionCollectionResponse.class, IIosManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IIosManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseIosManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIosManagedAppProtectionCollectionPage get() throws ClientException {
        BaseIosManagedAppProtectionCollectionResponse response = (BaseIosManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IosManagedAppProtection newIosManagedAppProtection, ICallback<IosManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIosManagedAppProtection, callback);
    }

    @Override
    public IosManagedAppProtection post(IosManagedAppProtection newIosManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIosManagedAppProtection);
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IosManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IosManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IosManagedAppProtectionCollectionRequest)this;
    }

    public IIosManagedAppProtectionCollectionPage buildFromResponse(BaseIosManagedAppProtectionCollectionResponse response) {
        IosManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new IosManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IosManagedAppProtectionCollectionPage page = new IosManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

