/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveRequest;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveRequest;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IListRequestBuilder;
import com.microsoft.graph.requests.extensions.ListRequestBuilder;
import com.microsoft.graph.requests.generated.IBaseDriveRequestBuilder;
import java.util.List;

public class BaseDriveRequestBuilder
extends BaseRequestBuilder
implements IBaseDriveRequestBuilder {
    public BaseDriveRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Override
    public IDriveRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public IDriveRequest buildRequest(List<? extends Option> requestOptions) {
        return new DriveRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Override
    public IDriveItemCollectionRequestBuilder items() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("items"), this.getClient(), null);
    }

    @Override
    public IDriveItemRequestBuilder items(String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("items") + "/" + id, this.getClient(), null);
    }

    @Override
    public IListRequestBuilder list() {
        return new ListRequestBuilder(this.getRequestUrlWithAdditionalSegment("list"), this.getClient(), null);
    }

    @Override
    public IDriveItemRequestBuilder root() {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("root"), this.getClient(), null);
    }

    @Override
    public IDriveItemCollectionRequestBuilder special() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("special"), this.getClient(), null);
    }

    @Override
    public IDriveItemRequestBuilder special(String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("special") + "/" + id, this.getClient(), null);
    }

    @Override
    public IDriveRecentCollectionRequestBuilder recent() {
        return new DriveRecentCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.recent"), this.getClient(), null);
    }

    @Override
    public IDriveSearchCollectionRequestBuilder search(String q) {
        return new DriveSearchCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.search"), this.getClient(), null, q);
    }

    @Override
    public IDriveSharedWithMeCollectionRequestBuilder sharedWithMe() {
        return new DriveSharedWithMeCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.sharedWithMe"), this.getClient(), null);
    }
}

