/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationUserStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationUserStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationUserStatusCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceConfigurationUserStatusCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceConfigurationUserStatusCollectionRequest;
import java.util.List;

public class BaseDeviceConfigurationUserStatusCollectionRequest
extends BaseCollectionRequest<BaseDeviceConfigurationUserStatusCollectionResponse, IDeviceConfigurationUserStatusCollectionPage>
implements IBaseDeviceConfigurationUserStatusCollectionRequest {
    public BaseDeviceConfigurationUserStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceConfigurationUserStatusCollectionResponse.class, IDeviceConfigurationUserStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceConfigurationUserStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceConfigurationUserStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionPage get() throws ClientException {
        BaseDeviceConfigurationUserStatusCollectionResponse response = (BaseDeviceConfigurationUserStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationUserStatus newDeviceConfigurationUserStatus, ICallback<DeviceConfigurationUserStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationUserStatus, callback);
    }

    @Override
    public DeviceConfigurationUserStatus post(DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationUserStatus);
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceConfigurationUserStatusCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceConfigurationUserStatusCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceConfigurationUserStatusCollectionRequest)this;
    }

    public IDeviceConfigurationUserStatusCollectionPage buildFromResponse(BaseDeviceConfigurationUserStatusCollectionResponse response) {
        DeviceConfigurationUserStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationUserStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationUserStatusCollectionPage page = new DeviceConfigurationUserStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

