/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceDeviceStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceComplianceDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceComplianceDeviceStatusCollectionRequest;
import java.util.List;

public class BaseDeviceComplianceDeviceStatusCollectionRequest
extends BaseCollectionRequest<BaseDeviceComplianceDeviceStatusCollectionResponse, IDeviceComplianceDeviceStatusCollectionPage>
implements IBaseDeviceComplianceDeviceStatusCollectionRequest {
    public BaseDeviceComplianceDeviceStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceComplianceDeviceStatusCollectionResponse.class, IDeviceComplianceDeviceStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceDeviceStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceComplianceDeviceStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionPage get() throws ClientException {
        BaseDeviceComplianceDeviceStatusCollectionResponse response = (BaseDeviceComplianceDeviceStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceDeviceStatus newDeviceComplianceDeviceStatus, ICallback<DeviceComplianceDeviceStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceDeviceStatus, callback);
    }

    @Override
    public DeviceComplianceDeviceStatus post(DeviceComplianceDeviceStatus newDeviceComplianceDeviceStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceDeviceStatus);
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceComplianceDeviceStatusCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceComplianceDeviceStatusCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceDeviceStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceComplianceDeviceStatusCollectionRequest)this;
    }

    public IDeviceComplianceDeviceStatusCollectionPage buildFromResponse(BaseDeviceComplianceDeviceStatusCollectionResponse response) {
        DeviceComplianceDeviceStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceDeviceStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceDeviceStatusCollectionPage page = new DeviceComplianceDeviceStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

