/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.logger;

import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import java.util.logging.Logger;

public class DefaultLogger
implements ILogger {
    private LoggerLevel level = LoggerLevel.ERROR;
    private static final Logger LOGGER = Logger.getLogger("global");

    @Override
    public void setLoggingLevel(LoggerLevel level) {
        LOGGER.info("Setting logging level to " + (Object)((Object)level));
        this.level = level;
    }

    @Override
    public LoggerLevel getLoggingLevel() {
        return this.level;
    }

    private String getTag() {
        try {
            StringBuilder sb = new StringBuilder();
            int callerStackDepth = 4;
            String className = Thread.currentThread().getStackTrace()[4].getClassName();
            sb.append(className.substring(className.lastIndexOf(46) + 1));
            sb.append("[");
            sb.append(Thread.currentThread().getStackTrace()[4].getMethodName());
            sb.append("] - ");
            sb.append(Thread.currentThread().getStackTrace()[4].getLineNumber());
            return sb.toString();
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
            return null;
        }
    }

    @Override
    public void logDebug(String message) {
        for (String line : message.split("\n")) {
            LOGGER.info(line);
        }
    }

    @Override
    public void logError(String message, Throwable throwable) {
        switch (this.level) {
            default: 
        }
        for (String line : message.split("\n")) {
            LOGGER.severe(this.getTag() + line);
        }
        LOGGER.severe("Throwable detail: " + throwable);
    }
}

