/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Workbook;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookRequest;
import com.microsoft.graph.requests.extensions.WorkbookRequest;
import com.microsoft.graph.requests.generated.IBaseWorkbookRequest;
import java.util.List;

public class BaseWorkbookRequest
extends BaseRequest
implements IBaseWorkbookRequest {
    public BaseWorkbookRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<Workbook> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Override
    public void get(ICallback<Workbook> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Workbook get() throws ClientException {
        return (Workbook)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Workbook> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Workbook sourceWorkbook, ICallback<Workbook> callback) {
        this.send(HttpMethod.PATCH, callback, sourceWorkbook);
    }

    @Override
    public Workbook patch(Workbook sourceWorkbook) throws ClientException {
        return (Workbook)this.send(HttpMethod.PATCH, sourceWorkbook);
    }

    @Override
    public void post(Workbook newWorkbook, ICallback<Workbook> callback) {
        this.send(HttpMethod.POST, callback, newWorkbook);
    }

    @Override
    public Workbook post(Workbook newWorkbook) throws ClientException {
        return (Workbook)this.send(HttpMethod.POST, newWorkbook);
    }

    @Override
    public IWorkbookRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (WorkbookRequest)this;
    }

    @Override
    public IWorkbookRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (WorkbookRequest)this;
    }
}

