/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TermsAndConditionsAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTermsAndConditionsAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTermsAndConditionsAssignmentCollectionRequest;
import java.util.List;

public class BaseTermsAndConditionsAssignmentCollectionRequest
extends BaseCollectionRequest<BaseTermsAndConditionsAssignmentCollectionResponse, ITermsAndConditionsAssignmentCollectionPage>
implements IBaseTermsAndConditionsAssignmentCollectionRequest {
    public BaseTermsAndConditionsAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTermsAndConditionsAssignmentCollectionResponse.class, ITermsAndConditionsAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITermsAndConditionsAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTermsAndConditionsAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionPage get() throws ClientException {
        BaseTermsAndConditionsAssignmentCollectionResponse response = (BaseTermsAndConditionsAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TermsAndConditionsAssignment newTermsAndConditionsAssignment, ICallback<TermsAndConditionsAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TermsAndConditionsAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTermsAndConditionsAssignment, callback);
    }

    @Override
    public TermsAndConditionsAssignment post(TermsAndConditionsAssignment newTermsAndConditionsAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TermsAndConditionsAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTermsAndConditionsAssignment);
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TermsAndConditionsAssignmentCollectionRequest)this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TermsAndConditionsAssignmentCollectionRequest)this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TermsAndConditionsAssignmentCollectionRequest)this;
    }

    public ITermsAndConditionsAssignmentCollectionPage buildFromResponse(BaseTermsAndConditionsAssignmentCollectionResponse response) {
        TermsAndConditionsAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new TermsAndConditionsAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TermsAndConditionsAssignmentCollectionPage page = new TermsAndConditionsAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

