/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Notebook;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INotebookCollectionPage;
import com.microsoft.graph.requests.extensions.INotebookCollectionRequest;
import com.microsoft.graph.requests.extensions.NotebookCollectionPage;
import com.microsoft.graph.requests.extensions.NotebookCollectionRequest;
import com.microsoft.graph.requests.extensions.NotebookCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NotebookRequestBuilder;
import com.microsoft.graph.requests.generated.BaseNotebookCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseNotebookCollectionRequest;
import java.util.List;

public class BaseNotebookCollectionRequest
extends BaseCollectionRequest<BaseNotebookCollectionResponse, INotebookCollectionPage>
implements IBaseNotebookCollectionRequest {
    public BaseNotebookCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseNotebookCollectionResponse.class, INotebookCollectionPage.class);
    }

    @Override
    public void get(final ICallback<INotebookCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseNotebookCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public INotebookCollectionPage get() throws ClientException {
        BaseNotebookCollectionResponse response = (BaseNotebookCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Notebook newNotebook, ICallback<Notebook> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new NotebookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newNotebook, callback);
    }

    @Override
    public Notebook post(Notebook newNotebook) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NotebookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newNotebook);
    }

    @Override
    public INotebookCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (NotebookCollectionRequest)this;
    }

    @Override
    public INotebookCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (NotebookCollectionRequest)this;
    }

    @Override
    public INotebookCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (NotebookCollectionRequest)this;
    }

    public INotebookCollectionPage buildFromResponse(BaseNotebookCollectionResponse response) {
        NotebookCollectionRequestBuilder builder = response.nextLink != null ? new NotebookCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        NotebookCollectionPage page = new NotebookCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

