/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.MobileAppCategory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.MobileAppCategoryWithReferenceRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileAppCategoryCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileAppCategoryCollectionReferenceRequest;
import java.util.List;

public class BaseMobileAppCategoryCollectionReferenceRequest
extends BaseCollectionRequest<BaseMobileAppCategoryCollectionResponse, IMobileAppCategoryCollectionPage>
implements IBaseMobileAppCategoryCollectionReferenceRequest {
    public BaseMobileAppCategoryCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileAppCategoryCollectionResponse.class, IMobileAppCategoryCollectionPage.class);
    }

    @Override
    public void post(MobileAppCategory newMobileAppCategory, ICallback<MobileAppCategory> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/deviceAppManagement/categories/" + newMobileAppCategory.id);
        new MobileAppCategoryWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppCategory, body, callback);
    }

    @Override
    public MobileAppCategory post(MobileAppCategory newMobileAppCategory) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/deviceAppManagement/categories/" + newMobileAppCategory.id);
        return new MobileAppCategoryWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppCategory, body);
    }

    public IMobileAppCategoryCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileAppCategoryCollectionReferenceRequest)this;
    }

    @Override
    public IMobileAppCategoryCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileAppCategoryCollectionReferenceRequest)this;
    }

    @Override
    public IMobileAppCategoryCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppCategoryCollectionReferenceRequest)this;
    }
}

