/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedDeviceMobileAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceMobileAppConfigurationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedDeviceMobileAppConfigurationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedDeviceMobileAppConfigurationCollectionRequest;
import java.util.List;

public class BaseManagedDeviceMobileAppConfigurationCollectionRequest
extends BaseCollectionRequest<BaseManagedDeviceMobileAppConfigurationCollectionResponse, IManagedDeviceMobileAppConfigurationCollectionPage>
implements IBaseManagedDeviceMobileAppConfigurationCollectionRequest {
    public BaseManagedDeviceMobileAppConfigurationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedDeviceMobileAppConfigurationCollectionResponse.class, IManagedDeviceMobileAppConfigurationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedDeviceMobileAppConfigurationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedDeviceMobileAppConfigurationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedDeviceMobileAppConfigurationCollectionPage get() throws ClientException {
        BaseManagedDeviceMobileAppConfigurationCollectionResponse response = (BaseManagedDeviceMobileAppConfigurationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedDeviceMobileAppConfiguration newManagedDeviceMobileAppConfiguration, ICallback<ManagedDeviceMobileAppConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedDeviceMobileAppConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedDeviceMobileAppConfiguration, callback);
    }

    @Override
    public ManagedDeviceMobileAppConfiguration post(ManagedDeviceMobileAppConfiguration newManagedDeviceMobileAppConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedDeviceMobileAppConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newManagedDeviceMobileAppConfiguration);
    }

    @Override
    public IManagedDeviceMobileAppConfigurationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedDeviceMobileAppConfigurationCollectionRequest)this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedDeviceMobileAppConfigurationCollectionRequest)this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedDeviceMobileAppConfigurationCollectionRequest)this;
    }

    public IManagedDeviceMobileAppConfigurationCollectionPage buildFromResponse(BaseManagedDeviceMobileAppConfigurationCollectionResponse response) {
        ManagedDeviceMobileAppConfigurationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedDeviceMobileAppConfigurationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedDeviceMobileAppConfigurationCollectionPage page = new ManagedDeviceMobileAppConfigurationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

