/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ListItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IListItemRequest;
import com.microsoft.graph.requests.extensions.ListItemRequest;
import com.microsoft.graph.requests.generated.IBaseListItemRequest;
import java.util.List;

public class BaseListItemRequest
extends BaseRequest
implements IBaseListItemRequest {
    public BaseListItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<ListItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Override
    public void get(ICallback<ListItem> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ListItem get() throws ClientException {
        return (ListItem)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ListItem> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ListItem sourceListItem, ICallback<ListItem> callback) {
        this.send(HttpMethod.PATCH, callback, sourceListItem);
    }

    @Override
    public ListItem patch(ListItem sourceListItem) throws ClientException {
        return (ListItem)this.send(HttpMethod.PATCH, sourceListItem);
    }

    @Override
    public void post(ListItem newListItem, ICallback<ListItem> callback) {
        this.send(HttpMethod.POST, callback, newListItem);
    }

    @Override
    public ListItem post(ListItem newListItem) throws ClientException {
        return (ListItem)this.send(HttpMethod.POST, newListItem);
    }

    @Override
    public IListItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (ListItemRequest)this;
    }

    @Override
    public IListItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (ListItemRequest)this;
    }
}

