/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationClassCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.EducationClassCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.EducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionWithReferencesRequest;
import com.microsoft.graph.requests.generated.BaseEducationClassCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseEducationClassCollectionWithReferencesRequest;
import java.util.List;

public class BaseEducationClassCollectionWithReferencesRequest
extends BaseCollectionRequest<BaseEducationClassCollectionResponse, IEducationClassCollectionPage>
implements IBaseEducationClassCollectionWithReferencesRequest {
    public BaseEducationClassCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationClassCollectionResponse.class, IEducationClassCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationClassCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEducationClassCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationClassCollectionWithReferencesPage get() throws ClientException {
        BaseEducationClassCollectionResponse response = (BaseEducationClassCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IEducationClassCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationClassCollectionWithReferencesRequest)this;
    }

    @Override
    public IEducationClassCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationClassCollectionWithReferencesRequest)this;
    }

    @Override
    public IEducationClassCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationClassCollectionWithReferencesRequest)this;
    }

    public IEducationClassCollectionWithReferencesPage buildFromResponse(BaseEducationClassCollectionResponse response) {
        EducationClassCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new EducationClassCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationClassCollectionWithReferencesPage page = new EducationClassCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

