/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Drive;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveRequest;
import com.microsoft.graph.requests.extensions.IDriveRequest;
import com.microsoft.graph.requests.generated.IBaseDriveRequest;
import java.util.List;

public class BaseDriveRequest
extends BaseRequest
implements IBaseDriveRequest {
    public BaseDriveRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<Drive> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Override
    public void get(ICallback<Drive> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Drive get() throws ClientException {
        return (Drive)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Drive> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Drive sourceDrive, ICallback<Drive> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDrive);
    }

    @Override
    public Drive patch(Drive sourceDrive) throws ClientException {
        return (Drive)this.send(HttpMethod.PATCH, sourceDrive);
    }

    @Override
    public void post(Drive newDrive, ICallback<Drive> callback) {
        this.send(HttpMethod.POST, callback, newDrive);
    }

    @Override
    public Drive post(Drive newDrive) throws ClientException {
        return (Drive)this.send(HttpMethod.POST, newDrive);
    }

    @Override
    public IDriveRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (DriveRequest)this;
    }

    @Override
    public IDriveRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (DriveRequest)this;
    }
}

