/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectWithReferenceRequest;
import com.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequest;
import com.microsoft.graph.requests.generated.IBaseDirectoryObjectWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class BaseDirectoryObjectWithReferenceRequest
extends BaseRequest
implements IBaseDirectoryObjectWithReferenceRequest {
    public BaseDirectoryObjectWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObject.class);
    }

    @Override
    public void post(DirectoryObject newDirectoryObject, IJsonBackedObject payload, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public DirectoryObject post(DirectoryObject newDirectoryObject, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newDirectoryObject;
        }
        return null;
    }

    @Override
    public void get(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DirectoryObject get() throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DirectoryObject sourceDirectoryObject, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDirectoryObject);
    }

    @Override
    public DirectoryObject patch(DirectoryObject sourceDirectoryObject) throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.PATCH, sourceDirectoryObject);
    }

    @Override
    public IDirectoryObjectWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (IDirectoryObjectWithReferenceRequest)((Object)this);
    }

    @Override
    public IDirectoryObjectWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (DirectoryObjectWithReferenceRequest)this;
    }
}

