/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceManagementPartner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceManagementPartnerCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceManagementPartnerCollectionRequest;
import java.util.List;

public class BaseDeviceManagementPartnerCollectionRequest
extends BaseCollectionRequest<BaseDeviceManagementPartnerCollectionResponse, IDeviceManagementPartnerCollectionPage>
implements IBaseDeviceManagementPartnerCollectionRequest {
    public BaseDeviceManagementPartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceManagementPartnerCollectionResponse.class, IDeviceManagementPartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceManagementPartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceManagementPartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceManagementPartnerCollectionPage get() throws ClientException {
        BaseDeviceManagementPartnerCollectionResponse response = (BaseDeviceManagementPartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceManagementPartner newDeviceManagementPartner, ICallback<DeviceManagementPartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementPartner, callback);
    }

    @Override
    public DeviceManagementPartner post(DeviceManagementPartner newDeviceManagementPartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceManagementPartner);
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceManagementPartnerCollectionRequest)this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceManagementPartnerCollectionRequest)this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceManagementPartnerCollectionRequest)this;
    }

    public IDeviceManagementPartnerCollectionPage buildFromResponse(BaseDeviceManagementPartnerCollectionResponse response) {
        DeviceManagementPartnerCollectionRequestBuilder builder = response.nextLink != null ? new DeviceManagementPartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceManagementPartnerCollectionPage page = new DeviceManagementPartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

