/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationDeviceStatusCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceConfigurationDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceConfigurationDeviceStatusCollectionRequest;
import java.util.List;

public class BaseDeviceConfigurationDeviceStatusCollectionRequest
extends BaseCollectionRequest<BaseDeviceConfigurationDeviceStatusCollectionResponse, IDeviceConfigurationDeviceStatusCollectionPage>
implements IBaseDeviceConfigurationDeviceStatusCollectionRequest {
    public BaseDeviceConfigurationDeviceStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceConfigurationDeviceStatusCollectionResponse.class, IDeviceConfigurationDeviceStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceConfigurationDeviceStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceConfigurationDeviceStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionPage get() throws ClientException {
        BaseDeviceConfigurationDeviceStatusCollectionResponse response = (BaseDeviceConfigurationDeviceStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus, ICallback<DeviceConfigurationDeviceStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationDeviceStatus, callback);
    }

    @Override
    public DeviceConfigurationDeviceStatus post(DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationDeviceStatus);
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceConfigurationDeviceStatusCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceConfigurationDeviceStatusCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceConfigurationDeviceStatusCollectionRequest)this;
    }

    public IDeviceConfigurationDeviceStatusCollectionPage buildFromResponse(BaseDeviceConfigurationDeviceStatusCollectionResponse response) {
        DeviceConfigurationDeviceStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationDeviceStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationDeviceStatusCollectionPage page = new DeviceConfigurationDeviceStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

