/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DefaultManagedAppProtection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IDefaultManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDefaultManagedAppProtectionCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDefaultManagedAppProtectionCollectionRequest;
import java.util.List;

public class BaseDefaultManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<BaseDefaultManagedAppProtectionCollectionResponse, IDefaultManagedAppProtectionCollectionPage>
implements IBaseDefaultManagedAppProtectionCollectionRequest {
    public BaseDefaultManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDefaultManagedAppProtectionCollectionResponse.class, IDefaultManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDefaultManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDefaultManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDefaultManagedAppProtectionCollectionPage get() throws ClientException {
        BaseDefaultManagedAppProtectionCollectionResponse response = (BaseDefaultManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DefaultManagedAppProtection newDefaultManagedAppProtection, ICallback<DefaultManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DefaultManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDefaultManagedAppProtection, callback);
    }

    @Override
    public DefaultManagedAppProtection post(DefaultManagedAppProtection newDefaultManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DefaultManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDefaultManagedAppProtection);
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DefaultManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DefaultManagedAppProtectionCollectionRequest)this;
    }

    @Override
    public IDefaultManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DefaultManagedAppProtectionCollectionRequest)this;
    }

    public IDefaultManagedAppProtectionCollectionPage buildFromResponse(BaseDefaultManagedAppProtectionCollectionResponse response) {
        DefaultManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new DefaultManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DefaultManagedAppProtectionCollectionPage page = new DefaultManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

