/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.content;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.models.BatchRequestStep;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class BatchRequestContent {
    private HashMap<String, BatchRequestStep> batchRequestSteps;
    private RequestAdapter requestAdapter;
    private final String maxStepsExceededMessage = String.format(Locale.US, "%s exceeds the maximum value of %d.", "Number of request steps", 20);
    private static final String AUTHORIZATION_HEADER_KEY = "authorization";

    public BatchRequestContent(@Nonnull IBaseClient client) {
        this(client, new ArrayList<BatchRequestStep>());
    }

    public BatchRequestContent(@Nonnull IBaseClient baseClient, @Nonnull List<BatchRequestStep> batchRequestSteps) {
        this(baseClient.getRequestAdapter(), batchRequestSteps);
    }

    public BatchRequestContent(@Nonnull RequestAdapter requestAdapter, @Nonnull List<BatchRequestStep> batchRequestSteps) {
        this.requestAdapter = Objects.requireNonNull(requestAdapter, "The following parameter cannot be null: requestAdapter");
        Objects.requireNonNull(batchRequestSteps, "The following parameter cannot be null: batchRequestSteps");
        if (batchRequestSteps.size() >= 20) {
            throw new IllegalArgumentException(this.maxStepsExceededMessage);
        }
        this.batchRequestSteps = new HashMap();
        for (BatchRequestStep requestStep : batchRequestSteps) {
            this.addBatchRequestStep(requestStep);
        }
    }

    @Nonnull
    public Map<String, BatchRequestStep> getBatchRequestSteps() {
        return new HashMap<String, BatchRequestStep>(this.batchRequestSteps);
    }

    public boolean addBatchRequestStep(@Nullable BatchRequestStep requestStep) {
        if (requestStep == null || this.batchRequestSteps.containsKey(requestStep.getRequestId()) || this.batchRequestSteps.size() >= 20) {
            return false;
        }
        if (!this.containsCorrespondingRequestId(requestStep.getDependsOn())) {
            throw new IllegalArgumentException("Corresponding batch request id not found for the specified dependsOn relation.");
        }
        this.batchRequestSteps.put(requestStep.getRequestId(), requestStep);
        return true;
    }

    @Nonnull
    public String addBatchRequestStep(@Nonnull Request request) {
        if (this.batchRequestSteps.size() >= 20) {
            throw new IllegalArgumentException(this.maxStepsExceededMessage);
        }
        String requestId = UUID.randomUUID().toString();
        BatchRequestStep requestStep = new BatchRequestStep(requestId, request);
        this.batchRequestSteps.put(requestId, requestStep);
        return requestId;
    }

    @Nonnull
    public String addBatchRequestStep(@Nonnull RequestInformation requestInformation) {
        if (this.batchRequestSteps.size() >= 20) {
            throw new IllegalArgumentException(this.maxStepsExceededMessage);
        }
        String requestId = UUID.randomUUID().toString();
        Request request = (Request)this.requestAdapter.convertToNativeRequest(requestInformation);
        BatchRequestStep requestStep = new BatchRequestStep(requestId, request);
        this.batchRequestSteps.put(requestId, requestStep);
        return requestId;
    }

    public boolean removeBatchRequestStepWithId(@Nonnull String requestId) {
        if (Compatibility.isBlank((String)requestId)) {
            throw new IllegalArgumentException("requestId cannot be null or empty.");
        }
        boolean isRemoved = false;
        if (this.batchRequestSteps.containsKey(requestId)) {
            this.batchRequestSteps.remove(requestId);
            isRemoved = true;
            for (BatchRequestStep requestStep : this.batchRequestSteps.values()) {
                requestStep.removeDependsOnId(requestId);
            }
        }
        return isRemoved;
    }

    @Nonnull
    public BatchRequestContent createNewBatchFromFailedRequests(@Nonnull Map<String, Integer> responseStatusCodes) {
        BatchRequestContent request = new BatchRequestContent(this.requestAdapter, new ArrayList<BatchRequestStep>());
        responseStatusCodes.forEach((key, value) -> {
            if (this.batchRequestSteps.containsKey(key) && !BatchResponseContent.isSuccessStatusCode(value)) {
                request.addBatchRequestStep(this.batchRequestSteps.get(key).getRequest());
            }
        });
        return request;
    }

    @Nonnull
    public InputStream getBatchRequestContent() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
        writer.beginObject();
        writer.name("requests");
        writer.beginArray();
        for (BatchRequestStep requestStep : this.batchRequestSteps.values()) {
            this.writeBatchRequestStep(requestStep, writer);
        }
        writer.endArray();
        writer.endObject();
        writer.flush();
        ByteArrayInputStream out = new ByteArrayInputStream(outputStream.toByteArray());
        outputStream.close();
        return out;
    }

    private void writeBatchRequestStep(BatchRequestStep requestStep, JsonWriter writer) throws IOException {
        Request request = requestStep.getRequest();
        writer.beginObject();
        writer.name("id").value(requestStep.getRequestId());
        writer.name("url").value(this.getRelativeUrl(request.url()));
        writer.name("method").value(request.method());
        List<String> dependsOn = requestStep.getDependsOn();
        if (!dependsOn.isEmpty()) {
            writer.name("dependsOn");
            writer.beginArray();
            for (String id : dependsOn) {
                writer.value(id);
            }
            writer.endArray();
        }
        RequestBody requestBody = request.body();
        Headers headers = request.headers();
        if (requestBody != null) {
            String contentType = Objects.requireNonNull(requestBody.contentType()).toString();
            headers = headers.newBuilder().add("Content-Type", contentType).build();
            writer.name("body");
            if (contentType.toLowerCase(Locale.US).contains("application/json")) {
                JsonObject bodyObject = this.getJsonRequestContent(requestBody);
                writer.jsonValue(bodyObject.toString());
            } else {
                String rawBodyContent = this.getRawRequestContent(requestBody);
                writer.value(rawBodyContent);
            }
        }
        if ((headers = headers.newBuilder().removeAll(AUTHORIZATION_HEADER_KEY).build()).size() != 0 || requestBody != null) {
            writer.name("headers");
            writer.beginObject();
            for (int i = 0; i < headers.size(); ++i) {
                writer.name(headers.name(i)).value(headers.value(i));
            }
            writer.endObject();
        }
        writer.endObject();
    }

    private JsonObject getJsonRequestContent(RequestBody requestBody) throws IOException {
        try {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return JsonParser.parseString((String)buffer.readUtf8()).getAsJsonObject();
        }
        catch (IOException e) {
            throw new IOException("Unable to deserialize content.", e);
        }
    }

    private String getRawRequestContent(RequestBody requestBody) throws IOException {
        try {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            throw new IOException("Unable to deserialize content.", e);
        }
    }

    private boolean containsCorrespondingRequestId(List<String> dependsOn) {
        return dependsOn.stream().allMatch(id -> this.batchRequestSteps.containsKey(id));
    }

    private String getRelativeUrl(HttpUrl url) {
        String query = url.encodedQuery();
        String path = url.encodedPath().substring(5);
        if (Compatibility.isBlank((String)query)) {
            return path;
        }
        return path + "?" + query;
    }
}

