/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests;

import com.microsoft.graph.core.CoreConstants;
import com.microsoft.graph.core.requests.middleware.GraphTelemetryHandler;
import com.microsoft.graph.core.requests.options.GraphClientOption;
import com.microsoft.kiota.http.KiotaClientFactory;
import com.microsoft.kiota.http.middleware.UrlReplaceHandler;
import com.microsoft.kiota.http.middleware.options.UrlReplaceHandlerOption;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class GraphClientFactory {
    private GraphClientFactory() {
    }

    @Nonnull
    public static OkHttpClient.Builder create() {
        return GraphClientFactory.create(new GraphClientOption());
    }

    @Nonnull
    public static OkHttpClient.Builder create(Interceptor ... interceptors) {
        return GraphClientFactory.create(new GraphClientOption(), interceptors);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull GraphClientOption graphClientOption, Interceptor ... interceptors) {
        OkHttpClient.Builder builder = GraphClientFactory.create(graphClientOption);
        ArrayList<String> appliedInterceptors = new ArrayList<String>();
        for (Interceptor interceptor : builder.interceptors()) {
            appliedInterceptors.add(interceptor.getClass().toString());
        }
        for (Interceptor interceptor : interceptors) {
            if (appliedInterceptors.contains(interceptor.getClass().toString())) continue;
            builder.addInterceptor(interceptor);
        }
        return builder;
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nullable GraphClientOption graphClientOption) {
        GraphClientOption options = graphClientOption != null ? graphClientOption : new GraphClientOption();
        return KiotaClientFactory.create((Interceptor[])GraphClientFactory.createDefaultGraphInterceptors(options));
    }

    @Nonnull
    public static Interceptor[] createDefaultGraphInterceptors(@Nonnull GraphClientOption graphClientOption) {
        ArrayList<Object> handlers = new ArrayList<Object>();
        GraphClientFactory.addDefaultFeatureUsages(graphClientOption);
        handlers.add(new UrlReplaceHandler(new UrlReplaceHandlerOption(CoreConstants.ReplacementConstants.getDefaultReplacementPairs())));
        handlers.add(new GraphTelemetryHandler(graphClientOption));
        handlers.addAll(Arrays.asList(KiotaClientFactory.createDefaultInterceptors()));
        return handlers.toArray(new Interceptor[0]);
    }

    private static void addDefaultFeatureUsages(GraphClientOption graphClientOption) {
        graphClientOption.featureTracker.setFeatureUsage(2);
        graphClientOption.featureTracker.setFeatureUsage(1);
        graphClientOption.featureTracker.setFeatureUsage(4096);
        graphClientOption.featureTracker.setFeatureUsage(512);
    }
}

