/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.GsonFactory;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSerializer
implements ISerializer {
    private static final String graphResponseHeadersKey = "graphResponseHeaders";
    private final Gson gson;
    private final ILogger logger;
    private static final String ODATA_TYPE_KEY = "@odata.type";

    public DefaultSerializer(@Nonnull ILogger logger) {
        this.logger = Objects.requireNonNull(logger, "parameter logger cannot be null");
        this.gson = GsonFactory.getGsonInstance(logger);
    }

    @Override
    @Nullable
    public <T> T deserializeObject(@Nonnull String inputString, @Nonnull Class<T> clazz, @Nullable Map<String, List<String>> responseHeaders) {
        Objects.requireNonNull(inputString, "parameter inputString cannot be null");
        JsonElement rawElement = (JsonElement)this.gson.fromJson(inputString, JsonElement.class);
        return this.deserializeObject(rawElement, clazz, responseHeaders);
    }

    @Override
    @Nullable
    public <T> T deserializeObject(@Nonnull InputStream inputStream, @Nonnull Class<T> clazz, @Nullable Map<String, List<String>> responseHeaders) {
        Objects.requireNonNull(inputStream, "parameter inputStream cannot be null");
        T result = null;
        try (InputStreamReader streamReader = new InputStreamReader(inputStream, "UTF-8");){
            JsonElement rawElement = (JsonElement)this.gson.fromJson((Reader)streamReader, JsonElement.class);
            result = this.deserializeObject(rawElement, clazz, responseHeaders);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    @Nullable
    public <T> T deserializeObject(@Nonnull JsonElement rawElement, @Nonnull Class<T> clazz, @Nullable Map<String, List<String>> responseHeaders) {
        Objects.requireNonNull(rawElement, "parameter rawElement cannot be null");
        Objects.requireNonNull(clazz, "parameter clazz cannot be null");
        Object jsonObject = this.gson.fromJson(rawElement, clazz);
        if (jsonObject instanceof IJsonBackedObject) {
            Class<?> derivedClass;
            this.logger.logDebug("Deserializing type " + clazz.getSimpleName());
            JsonObject rawObject = rawElement.isJsonObject() ? rawElement.getAsJsonObject() : null;
            Object jo = jsonObject;
            if (rawElement.isJsonObject() && (derivedClass = this.getDerivedClass(rawObject, clazz)) != null) {
                jo = this.gson.fromJson(rawElement, derivedClass);
            }
            IJsonBackedObject jsonBackedObject = (IJsonBackedObject)jo;
            if (rawElement.isJsonObject()) {
                jsonBackedObject.setRawObject(this, rawObject);
                jsonBackedObject.additionalDataManager().setAdditionalData(rawObject);
                this.setChildAdditionalData(jsonBackedObject, rawObject);
            }
            if (responseHeaders != null) {
                JsonElement convertedHeaders = this.gson.toJsonTree(responseHeaders);
                jsonBackedObject.additionalDataManager().put(graphResponseHeadersKey, convertedHeaders);
            }
            return (T)jo;
        }
        this.logger.logDebug("Deserializing a non-IJsonBackedObject type " + clazz.getSimpleName());
        return (T)jsonObject;
    }

    private void setChildAdditionalData(IJsonBackedObject serializedObject, JsonObject rawJson) {
        if (rawJson != null) {
            for (Field field : serializedObject.getClass().getFields()) {
                try {
                    if (field == null) continue;
                    Object fieldObject = field.get(serializedObject);
                    if (fieldObject instanceof HashMap) {
                        HashMap serializableChildren = (HashMap)fieldObject;
                        for (Map.Entry pair : serializableChildren.entrySet()) {
                            Object child = pair.getValue();
                            if (!(child instanceof IJsonBackedObject)) continue;
                            AdditionalDataManager childAdditionalDataManager = ((IJsonBackedObject)child).additionalDataManager();
                            JsonElement fieldElement = rawJson.get(field.getName());
                            if (fieldElement == null || !fieldElement.isJsonObject() || fieldElement.getAsJsonObject().get((String)pair.getKey()) == null || !fieldElement.getAsJsonObject().get((String)pair.getKey()).isJsonObject()) continue;
                            childAdditionalDataManager.setAdditionalData(fieldElement.getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                            this.setChildAdditionalData((IJsonBackedObject)child, fieldElement.getAsJsonObject().get((String)pair.getKey()).getAsJsonObject());
                        }
                        continue;
                    }
                    if (fieldObject instanceof List) {
                        JsonElement collectionJson = rawJson.get(field.getName());
                        List fieldObjectList = (List)fieldObject;
                        if (collectionJson == null || !collectionJson.isJsonArray()) continue;
                        JsonArray rawJsonArray = (JsonArray)collectionJson;
                        int fieldObjectListSize = fieldObjectList.size();
                        int rawJsonArraySize = rawJsonArray.size();
                        for (int i = 0; i < fieldObjectListSize && i < rawJsonArraySize; ++i) {
                            JsonElement elementRawJson;
                            Object element = fieldObjectList.get(i);
                            if (!(element instanceof IJsonBackedObject) || (elementRawJson = rawJsonArray.get(i)) == null) continue;
                            this.setChildAdditionalData((IJsonBackedObject)element, elementRawJson.getAsJsonObject());
                        }
                        if (rawJsonArraySize == fieldObjectListSize) continue;
                        this.logger.logDebug("rawJsonArray has a size of " + rawJsonArraySize + " and fieldObjectList of " + fieldObjectListSize);
                        continue;
                    }
                    if (!(fieldObject instanceof IJsonBackedObject)) continue;
                    IJsonBackedObject serializedChild = (IJsonBackedObject)fieldObject;
                    AdditionalDataManager childAdditionalDataManager = serializedChild.additionalDataManager();
                    JsonElement fieldElement = rawJson.get(field.getName());
                    if (fieldElement == null || !fieldElement.isJsonObject()) continue;
                    childAdditionalDataManager.setAdditionalData(fieldElement.getAsJsonObject());
                    this.setChildAdditionalData((IJsonBackedObject)fieldObject, fieldElement.getAsJsonObject());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    this.logger.logError("Unable to set child fields of " + serializedObject.getClass().getSimpleName(), e);
                    this.logger.logDebug(rawJson.getAsString());
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> String serializeObject(@Nonnull T serializableObject) {
        Objects.requireNonNull(serializableObject, "parameter serializableObject cannot be null");
        this.logger.logDebug("Serializing type " + serializableObject.getClass().getSimpleName());
        JsonElement outJsonTree = this.gson.toJsonTree(serializableObject);
        if (outJsonTree != null) {
            this.getChildAdditionalData(serializableObject, outJsonTree);
            return outJsonTree.toString();
        }
        return "";
    }

    private void getChildAdditionalData(Object serializableObject, JsonElement outJson) {
        if (outJson == null || serializableObject == null || !outJson.isJsonObject()) {
            return;
        }
        JsonObject outJsonObject = outJson.getAsJsonObject();
        this.addAdditionalDataFromJsonObjectToJson(serializableObject, outJsonObject);
        for (Field field : serializableObject.getClass().getFields()) {
            try {
                Object fieldObject = field.get(serializableObject);
                JsonElement fieldJsonElement = outJsonObject.get(field.getName());
                if (fieldObject == null || fieldJsonElement == null) continue;
                if (fieldObject instanceof Map && fieldJsonElement.isJsonObject()) {
                    Map serializableChildren = (Map)fieldObject;
                    Iterator it = serializableChildren.entrySet().iterator();
                    JsonObject fieldJsonObject = fieldJsonElement.getAsJsonObject();
                    while (it.hasNext()) {
                        Map.Entry pair = it.next();
                        Object child = pair.getValue();
                        JsonElement childJsonElement = fieldJsonObject.get(((String)pair.getKey()).toString());
                        this.getChildAdditionalData(child, childJsonElement);
                    }
                    continue;
                }
                if (fieldObject instanceof List && fieldJsonElement.isJsonArray()) {
                    JsonArray fieldArrayValue = fieldJsonElement.getAsJsonArray();
                    List fieldObjectList = (List)fieldObject;
                    for (int index = 0; index < fieldObjectList.size(); ++index) {
                        Object item = fieldObjectList.get(index);
                        JsonElement itemJsonElement = fieldArrayValue.get(index);
                        this.getChildAdditionalData(item, itemJsonElement);
                    }
                    continue;
                }
                if (!fieldJsonElement.isJsonObject()) continue;
                JsonObject fieldJsonObject = fieldJsonElement.getAsJsonObject();
                this.getChildAdditionalData(fieldObject, (JsonElement)fieldJsonObject);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.logError("Unable to access child fields of " + serializableObject.getClass().getSimpleName(), e);
            }
        }
    }

    private void addAdditionalDataFromJsonObjectToJson(Object item, JsonObject itemJsonObject) {
        if (item instanceof IJsonBackedObject && itemJsonObject != null) {
            IJsonBackedObject serializableItem = (IJsonBackedObject)item;
            AdditionalDataManager itemAdditionalData = serializableItem.additionalDataManager();
            this.addAdditionalDataFromManagerToJson(itemAdditionalData, itemJsonObject);
        }
    }

    private void addAdditionalDataFromManagerToJson(AdditionalDataManager additionalDataManager, JsonObject jsonNode) {
        for (Map.Entry entry : additionalDataManager.entrySet()) {
            if (((String)entry.getKey()).equals(graphResponseHeadersKey)) continue;
            jsonNode.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    @Nullable
    public Class<?> getDerivedClass(@Nonnull JsonObject jsonObject, @Nullable Class<?> parentClass) {
        Objects.requireNonNull(jsonObject, "parameter jsonObject cannot be null");
        if (jsonObject.get(ODATA_TYPE_KEY) != null) {
            String odataType = jsonObject.get(ODATA_TYPE_KEY).getAsString();
            int lastDotIndex = odataType.lastIndexOf(".");
            String derivedType = (odataType.substring(0, lastDotIndex) + ".models." + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, odataType.substring(lastDotIndex + 1))).replace("#", "com.");
            try {
                Class<?> derivedClass = Class.forName(derivedType);
                if (parentClass == null || parentClass.isAssignableFrom(derivedClass)) {
                    return derivedClass;
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.logger.logDebug("Unable to find a corresponding class for derived type " + derivedType + ". Falling back to parent class.");
                return null;
            }
        }
        return null;
    }

    @Nullable
    public ILogger getLogger() {
        return this.logger;
    }
}

