/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.graph.core.DateOnly;
import com.microsoft.graph.core.TimeOfDay;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionResponse;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ByteArraySerializer;
import com.microsoft.graph.serializer.CollectionPageSerializer;
import com.microsoft.graph.serializer.CollectionResponseSerializer;
import com.microsoft.graph.serializer.EdmNativeTypeSerializer;
import com.microsoft.graph.serializer.EnumSetSerializer;
import com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import com.microsoft.graph.serializer.OffsetDateTimeSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

final class GsonFactory {
    protected static String PARSING_MESSAGE = "Parsing issue on ";

    private GsonFactory() {
    }

    public static Gson getGsonInstance(final ILogger logger) {
        JsonSerializer<OffsetDateTime> calendarJsonSerializer = new JsonSerializer<OffsetDateTime>(){

            public JsonElement serialize(OffsetDateTime src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                try {
                    return new JsonPrimitive(OffsetDateTimeSerializer.serialize(src));
                }
                catch (Exception e) {
                    logger.logError(PARSING_MESSAGE + src, e);
                    return null;
                }
            }
        };
        JsonDeserializer<OffsetDateTime> calendarJsonDeserializer = new JsonDeserializer<OffsetDateTime>(){

            public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return OffsetDateTimeSerializer.deserialize(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        JsonSerializer<byte[]> byteArrayJsonSerializer = new JsonSerializer<byte[]>(){

            public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                try {
                    return new JsonPrimitive(ByteArraySerializer.serialize(src));
                }
                catch (Exception e) {
                    logger.logError(PARSING_MESSAGE + Arrays.toString(src), e);
                    return null;
                }
            }
        };
        JsonDeserializer<byte[]> byteArrayJsonDeserializer = new JsonDeserializer<byte[]>(){

            public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return ByteArraySerializer.deserialize(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        JsonSerializer<DateOnly> dateJsonSerializer = new JsonSerializer<DateOnly>(){

            public JsonElement serialize(DateOnly src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                return new JsonPrimitive(src.toString());
            }
        };
        JsonDeserializer<DateOnly> dateJsonDeserializer = new JsonDeserializer<DateOnly>(){

            public DateOnly deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return DateOnly.parse(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        final EnumSetSerializer eSetSerializer = new EnumSetSerializer(logger);
        JsonSerializer enumSetJsonSerializer = new JsonSerializer<EnumSet<?>>(){

            public JsonElement serialize(EnumSet<?> src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null || src.isEmpty()) {
                    return null;
                }
                return eSetSerializer.serialize(src);
            }
        };
        JsonDeserializer enumSetJsonDeserializer = new JsonDeserializer<EnumSet<?>>(){

            public EnumSet<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                return eSetSerializer.deserialize(typeOfT, json.getAsString());
            }
        };
        JsonSerializer<Duration> durationJsonSerializer = new JsonSerializer<Duration>(){

            public JsonElement serialize(Duration src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        };
        JsonDeserializer<Duration> durationJsonDeserializer = new JsonDeserializer<Duration>(){

            public Duration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return DatatypeFactory.newInstance().newDuration(json.getAsString());
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        JsonSerializer collectionPageSerializer = new JsonSerializer<BaseCollectionPage<?, ?>>(){

            public JsonElement serialize(BaseCollectionPage<?, ?> src, Type typeOfSrc, JsonSerializationContext context) {
                return CollectionPageSerializer.serialize(src, logger);
            }
        };
        JsonDeserializer collectionPageDeserializer = new JsonDeserializer<BaseCollectionPage<?, ?>>(){

            public BaseCollectionPage<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return CollectionPageSerializer.deserialize(json, typeOfT, logger);
            }
        };
        JsonDeserializer collectionResponseDeserializer = new JsonDeserializer<BaseCollectionResponse<?>>(){

            public BaseCollectionResponse<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return CollectionResponseSerializer.deserialize(json, typeOfT, logger);
            }
        };
        JsonDeserializer<TimeOfDay> timeOfDayJsonDeserializer = new JsonDeserializer<TimeOfDay>(){

            public TimeOfDay deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return TimeOfDay.parse(json.getAsString());
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        JsonSerializer<TimeOfDay> timeOfDayJsonSerializer = new JsonSerializer<TimeOfDay>(){

            public JsonElement serialize(TimeOfDay src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        };
        JsonDeserializer<Boolean> booleanJsonDeserializer = new JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, Boolean.class, logger);
            }
        };
        JsonDeserializer<String> stringJsonDeserializer = new JsonDeserializer<String>(){

            public String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, String.class, logger);
            }
        };
        JsonDeserializer<BigDecimal> bigDecimalJsonDeserializer = new JsonDeserializer<BigDecimal>(){

            public BigDecimal deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, BigDecimal.class, logger);
            }
        };
        JsonDeserializer<Integer> integerJsonDeserializer = new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, Integer.class, logger);
            }
        };
        JsonDeserializer<Long> longJsonDeserializer = new JsonDeserializer<Long>(){

            public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, Long.class, logger);
            }
        };
        JsonDeserializer<UUID> uuidJsonDeserializer = new JsonDeserializer<UUID>(){

            public UUID deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, UUID.class, logger);
            }
        };
        JsonDeserializer<Float> floatJsonDeserializer = new JsonDeserializer<Float>(){

            public Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return EdmNativeTypeSerializer.deserialize(json, Float.class, logger);
            }
        };
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Boolean.class, (Object)booleanJsonDeserializer).registerTypeAdapter(String.class, (Object)stringJsonDeserializer).registerTypeAdapter(Float.class, (Object)floatJsonDeserializer).registerTypeAdapter(Integer.class, (Object)integerJsonDeserializer).registerTypeAdapter(BigDecimal.class, (Object)bigDecimalJsonDeserializer).registerTypeAdapter(UUID.class, (Object)uuidJsonDeserializer).registerTypeAdapter(Long.class, (Object)longJsonDeserializer).registerTypeAdapter(OffsetDateTime.class, (Object)calendarJsonSerializer).registerTypeAdapter(OffsetDateTime.class, (Object)calendarJsonDeserializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonSerializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonDeserializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonSerializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonDeserializer).registerTypeAdapter(Duration.class, (Object)durationJsonSerializer).registerTypeAdapter(Duration.class, (Object)durationJsonDeserializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, (Object)collectionPageSerializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, (Object)collectionPageDeserializer).registerTypeHierarchyAdapter(BaseCollectionResponse.class, (Object)collectionResponseDeserializer).registerTypeAdapter(TimeOfDay.class, (Object)timeOfDayJsonDeserializer).registerTypeAdapter(TimeOfDay.class, (Object)timeOfDayJsonSerializer).registerTypeAdapterFactory((TypeAdapterFactory)new FallbackTypeAdapterFactory(logger)).create();
    }
}

