/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.content.BatchRequestStep;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchRequestContent {
    @Expose
    @Nullable
    @SerializedName(value="requests")
    public List<BatchRequestStep<?>> requests;
    private static final String contentTypeHeaderKey = "content-type";
    @Nonnull
    protected static final Pattern protocolAndHostReplacementPattern = Pattern.compile("(?i)^http[s]?:\\/\\/graph\\.microsoft\\.com\\/(?>v1\\.0|beta)\\/?");

    @Nonnull
    public String addBatchRequestStep(@Nonnull IHttpRequest request) {
        Objects.requireNonNull(request, "request parameter cannot be null");
        return this.addBatchRequestStep(request, request.getHttpMethod() == null ? HttpMethod.GET : request.getHttpMethod());
    }

    @Nonnull
    public String addBatchRequestStep(@Nonnull IHttpRequest request, @Nonnull HttpMethod httpMethod) {
        return this.addBatchRequestStep(request, httpMethod, null);
    }

    @Nonnull
    public <T> String addBatchRequestStep(@Nonnull IHttpRequest request, @Nonnull HttpMethod httpMethod, @Nullable T serializableBody) {
        return this.addBatchRequestStep(request, httpMethod, serializableBody, null);
    }

    @Nonnull
    public <T> String addBatchRequestStep(@Nonnull IHttpRequest request, final @Nonnull HttpMethod httpMethod, final @Nullable T serializableBody, final String ... dependsOnRequestsIds) {
        Objects.requireNonNull(request, "request parameter cannot be null");
        Objects.requireNonNull(httpMethod, "httpMethod parameter cannot be null");
        if (dependsOnRequestsIds != null) {
            for (String id : dependsOnRequestsIds) {
                if (this.getStepById(id) != null) continue;
                throw new IllegalArgumentException("the current request depends on a inexisting request");
            }
        }
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        final Matcher protocolAndHostReplacementMatcher = protocolAndHostReplacementPattern.matcher(request.getRequestUrl().toString());
        BatchRequestStep step = new BatchRequestStep<T>(){
            {
                this.url = protocolAndHostReplacementMatcher.replaceAll("");
                this.body = serializableBody;
                this.method = httpMethod.toString().toUpperCase(Locale.getDefault());
                this.dependsOn = dependsOnRequestsIds != null && dependsOnRequestsIds.length > 0 ? new HashSet<String>(Arrays.asList(dependsOnRequestsIds)) : null;
                this.id = BatchRequestContent.this.getNextRequestId();
            }
        };
        if (!request.getHeaders().isEmpty()) {
            step.headers = new HashMap();
            for (HeaderOption headerOption : request.getHeaders()) {
                step.headers.putIfAbsent(headerOption.getName().toLowerCase(Locale.getDefault()), headerOption.getValue().toString());
            }
        }
        if (step.body != null && step.body instanceof IJsonBackedObject && (step.headers == null || !step.headers.containsKey(contentTypeHeaderKey))) {
            if (step.headers == null) {
                step.headers = new HashMap();
            }
            step.headers.putIfAbsent(contentTypeHeaderKey, "application/json");
        }
        this.requests.add(step);
        return step.id;
    }

    public void removeBatchRequestStepWithId(String ... stepIds) {
        if (this.requests == null) {
            return;
        }
        for (String stepId : stepIds) {
            Objects.requireNonNull(stepId, "parameter stepIds cannot contain null values");
            this.requests.removeIf(x -> stepId.equals(x.id));
            for (BatchRequestStep<?> step : this.requests) {
                if (step.dependsOn == null) continue;
                step.dependsOn.removeIf(x -> stepId.equals(x));
                if (!step.dependsOn.isEmpty()) continue;
                step.dependsOn = null;
            }
        }
    }

    @Nullable
    public <T> BatchRequestStep<T> getStepById(@Nonnull String stepId) {
        Objects.requireNonNull(stepId, "parameter stepId cannot be null");
        if (this.requests == null) {
            return null;
        }
        for (BatchRequestStep<?> step : this.requests) {
            if (!stepId.equals(step.id)) continue;
            return step;
        }
        return null;
    }

    @Nonnull
    protected String getNextRequestId() {
        String requestId;
        while (this.getStepById(requestId = Integer.toString(ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE))) != null) {
        }
        return requestId;
    }
}

