// ------------------------------------------------------------------------------
// Copyright (c) 2020 Microsoft Corporation
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.microsoft.graph.http;

import javax.annotation.Nullable;

import java.util.Objects;

import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;

/**
 * The class for the Primitive Request Builder.
 * @param <T> the primitive type to deserialize the response to
 */
public class PrimitiveRequestBuilder<T> extends BaseRequestBuilder<T> {

    private final Class<T> _returnTypeClass;
    /**
     * The request builder for the primitive type
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param primitiveTypeClass the return type class for the request
     */
    public PrimitiveRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final Class<T> primitiveTypeClass) {
        super(requestUrl, client, requestOptions);
        this._returnTypeClass = Objects.requireNonNull(primitiveTypeClass, "paramter primitiveTypeClass cannot be null");
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrimitiveRequest instance
     */
    @Nonnull
    public PrimitiveRequest<T> buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PrimitiveRequest instance
     */
    @Nonnull
    public PrimitiveRequest<T> buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new PrimitiveRequest<>(getRequestUrl(), getClient(), requestOptions, this._returnTypeClass);
    }
}
