/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.options.HeaderOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Multipart {
    private String boundary;
    private static final String RETURN = "\r\n";
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    public static final String MULTIPART_ENCODING = "US-ASCII";
    private String contentType = "multipart/form-data";

    public Multipart() {
        this.boundary = "part_" + new BigInteger(130, new SecureRandom());
    }

    @Nonnull
    public String getBoundary() {
        return this.boundary;
    }

    public void setBoundary(@Nonnull String boundary) {
        this.boundary = Objects.requireNonNull(boundary, "parameter boundary cannot be null");
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(@Nonnull String contentType) {
        this.contentType = Objects.requireNonNull(contentType, "parameter contentType cannot be null");
    }

    @Nonnull
    public HeaderOption header() {
        return new HeaderOption("Content-Type", this.contentType + "; boundary=\"" + this.boundary + "\"");
    }

    private void writePartData(String partContent, byte[] byteArray) throws IOException {
        this.out.write(partContent.getBytes(MULTIPART_ENCODING));
        this.out.write(byteArray);
        String returnContent = "\r\n\r\n";
        this.out.write(returnContent.getBytes(MULTIPART_ENCODING));
    }

    @VisibleForTesting
    String createPartHeader(String name, String contentType, String filename) {
        StringBuilder partContent = new StringBuilder(this.addBoundary());
        partContent.append("Content-Disposition: form-data");
        if (filename != null) {
            if (name != null) {
                partContent.append("; name=\"").append(name).append("\"; filename=\"").append(filename).append("\"");
            } else {
                partContent.append("; filename=\"").append(filename).append("\"");
            }
        } else if (name != null) {
            partContent.append("; name=\"").append(name).append("\"");
        }
        if (contentType != null) {
            partContent.append(RETURN).append("Content-Type: ").append(contentType);
        }
        partContent.append(RETURN).append(RETURN);
        return partContent.toString();
    }

    @Nonnull
    public static String createContentHeaderValue(@Nonnull String contentValue, @Nullable Map<String, String> contentDispParameter) {
        StringBuilder builder = new StringBuilder(contentValue);
        if (contentDispParameter != null) {
            for (Map.Entry<String, String> entry : contentDispParameter.entrySet()) {
                builder.append(";").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
        }
        return builder.toString();
    }

    private String createPartHeader(Map<String, String> headers) {
        StringBuilder builder = new StringBuilder(this.addBoundary());
        String defaultPartContent = "Content-Disposition: form-data;\r\nContent-Type: " + this.contentType + RETURN + RETURN;
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(RETURN);
            }
            builder.append(RETURN);
        } else {
            builder.append(defaultPartContent);
        }
        return builder.toString();
    }

    private void addData(String name, String contentType, String filename, byte[] byteArray) throws IOException {
        String partContent = this.createPartHeader(name, contentType, filename);
        this.writePartData(partContent, byteArray);
    }

    public void addFormData(@Nonnull String name, @Nonnull String contentType, @Nonnull byte[] byteArray) throws IOException {
        this.addData(name, contentType, null, byteArray);
    }

    public void addPart(@Nonnull String contentType, @Nonnull byte[] byteArray) throws IOException {
        this.addData(null, contentType, null, byteArray);
    }

    public void addPart(@Nonnull Map<String, String> headers, @Nonnull byte[] content) throws IOException {
        String partContent = this.createPartHeader(headers);
        this.writePartData(partContent, content);
    }

    public void addHtmlPart(@Nonnull String name, @Nonnull byte[] content) throws IOException {
        this.addFormData(name, "text/html", content);
    }

    public void addFilePart(@Nonnull String name, @Nonnull String contentType, @Nonnull File file) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(file);){
            byte[] fileBytes = this.getByteArray(fileStream);
            this.addData(name, contentType, file.getName(), fileBytes);
        }
    }

    private String addBoundary() {
        return "--" + this.boundary + RETURN;
    }

    private String addEnding() {
        return "--" + this.boundary + "--";
    }

    @Nullable
    public byte[] content() throws IOException {
        ByteArrayOutputStream finalStream = this.out;
        finalStream.write(this.addEnding().getBytes(MULTIPART_ENCODING));
        return finalStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteArray(InputStream in) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            byte[] data = new byte[16384];
            try {
                int nRead;
                while ((nRead = in.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
            }
            finally {
                in.close();
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }
}

