/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.tasks;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.tasks.IProgressCallback;
import com.microsoft.graph.tasks.IUploadSession;
import com.microsoft.graph.tasks.LargeFileUploadRequest;
import com.microsoft.graph.tasks.LargeFileUploadResponse;
import com.microsoft.graph.tasks.LargeFileUploadResponseHandler;
import com.microsoft.graph.tasks.LargeFileUploadResult;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LargeFileUploadTask<UploadType> {
    private static final int DEFAULT_CHUNK_SIZE = 0x500000;
    private static final int REQUIRED_CHUNK_SIZE_INCREMENT = 327680;
    private static final int MAXIMUM_CHUNK_SIZE = 0x3C00000;
    private final IBaseClient<?> client;
    private final InputStream inputStream;
    private final String uploadUrl;
    private final long streamSize;
    private final LargeFileUploadResponseHandler<UploadType> responseHandler;
    private long readSoFar;

    public LargeFileUploadTask(@Nonnull IUploadSession uploadSession, @Nonnull IBaseClient<?> client, @Nonnull InputStream inputStream, long streamSize, @Nonnull Class<UploadType> uploadTypeClass) {
        Objects.requireNonNull(uploadSession, "Upload session is null.");
        if (streamSize <= 0L) {
            throw new InvalidParameterException("Stream size should larger than 0.");
        }
        this.client = Objects.requireNonNull(client, "Graph client is null.");
        this.readSoFar = 0L;
        this.inputStream = Objects.requireNonNull(inputStream, "Input stream is null.");
        this.streamSize = streamSize;
        this.uploadUrl = uploadSession.getUploadUrl();
        this.responseHandler = new LargeFileUploadResponseHandler<UploadType>(uploadTypeClass, uploadSession.getClass());
    }

    @Nonnull
    public CompletableFuture<LargeFileUploadResult<UploadType>> uploadAsync(@Nullable int chunkSize, @Nullable List<Option> options, @Nullable IProgressCallback progressCallback) throws IOException {
        int internalChunkSize = chunkSize;
        if (internalChunkSize == 0) {
            internalChunkSize = 0x500000;
        }
        if (internalChunkSize % 327680 != 0) {
            throw new IllegalArgumentException("Chunk size must be a multiple of 320 KiB");
        }
        if (internalChunkSize > 0x3C00000) {
            throw new IllegalArgumentException("Please set chunk size smaller than 60 MiB");
        }
        byte[] buffer = new byte[internalChunkSize];
        while (this.readSoFar < this.streamSize) {
            LargeFileUploadRequest<UploadType> request;
            LargeFileUploadResponse response;
            int buffRead;
            int read;
            for (buffRead = 0; buffRead < internalChunkSize; buffRead += read) {
                read = 0;
                read = this.inputStream.read(buffer, buffRead, internalChunkSize - buffRead);
                if (read == -1) break;
            }
            if ((response = (request = new LargeFileUploadRequest<UploadType>(this.uploadUrl, this.client, options, buffer, buffRead, this.readSoFar, this.streamSize)).upload(this.responseHandler)).uploadCompleted()) {
                if (progressCallback != null) {
                    progressCallback.progress(this.streamSize, this.streamSize);
                }
                LargeFileUploadResult result = new LargeFileUploadResult();
                if (response.getItem() != null) {
                    result.responseBody = response.getItem();
                }
                if (response.getLocation() != null) {
                    result.location = response.getLocation();
                }
                return this.completedFuture(result);
            }
            if (response.chunkCompleted()) {
                if (progressCallback != null) {
                    progressCallback.progress(this.readSoFar, this.streamSize);
                }
            } else if (response.hasError()) {
                return this.failedFuture(response.getError());
            }
            this.readSoFar += (long)buffRead;
        }
        return this.failedFuture(new ClientException("Upload did not complete", null));
    }

    private CompletableFuture<LargeFileUploadResult<UploadType>> completedFuture(LargeFileUploadResult<UploadType> result) {
        CompletableFuture<LargeFileUploadResult<UploadType>> fut = new CompletableFuture<LargeFileUploadResult<UploadType>>();
        fut.complete(result);
        return fut;
    }

    private CompletableFuture<LargeFileUploadResult<UploadType>> failedFuture(ClientException ex) {
        CompletableFuture<LargeFileUploadResult<UploadType>> fut = new CompletableFuture<LargeFileUploadResult<UploadType>>();
        fut.completeExceptionally(ex);
        return fut;
    }

    @Nonnull
    public CompletableFuture<LargeFileUploadResult<UploadType>> uploadAsync() throws IOException {
        return this.uploadAsync(0);
    }

    @Nonnull
    public CompletableFuture<LargeFileUploadResult<UploadType>> uploadAsync(@Nullable int chunkSize) throws IOException {
        return this.uploadAsync(chunkSize, null);
    }

    @Nonnull
    public CompletableFuture<LargeFileUploadResult<UploadType>> uploadAsync(@Nullable int chunkSize, @Nullable List<Option> options) throws IOException {
        return this.uploadAsync(chunkSize, options, null);
    }

    @Nonnull
    public LargeFileUploadResult<UploadType> upload(@Nullable int chunkSize, @Nullable List<Option> options, @Nullable IProgressCallback progressCallback) throws IOException {
        try {
            return this.uploadAsync(chunkSize, options, progressCallback).get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ClientException("The request was interrupted", ex);
        }
        catch (ExecutionException ex) {
            throw new ClientException("Error while executing the request", ex);
        }
    }

    @Nonnull
    public LargeFileUploadResult<UploadType> upload(@Nullable int chunkSize, @Nullable List<Option> options) throws IOException {
        return this.upload(chunkSize, options, null);
    }

    @Nonnull
    public LargeFileUploadResult<UploadType> upload(@Nullable int chunkSize) throws IOException {
        return this.upload(chunkSize, null);
    }

    @Nonnull
    public LargeFileUploadResult<UploadType> upload() throws IOException {
        return this.upload(0);
    }
}

