/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TelemetryHandler
implements Interceptor {
    public static final String SDK_VERSION = "SdkVersion";
    public static final String VERSION = "v2.0.11";
    public static final String GRAPH_VERSION_PREFIX = "graph-java-core";
    public static final String JAVA_VERSION_PREFIX = "java";
    public static final String ANDROID_VERSION_PREFIX = "android";
    public static final String CLIENT_REQUEST_ID = "client-request-id";
    private static final String DEFAULT_VERSION_VALUE = "0";
    private String androidAPILevel;

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder telemetryAddedBuilder = request.newBuilder();
        TelemetryOptions telemetryOptions = (TelemetryOptions)request.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
        }
        String featureUsage = "(featureUsage=" + telemetryOptions.getFeatureUsage() + ")";
        String javaVersion = System.getProperty("java.version");
        String androidVersion = this.getAndroidAPILevel();
        String sdkversion_value = "graph-java-core/v2.0.11 " + featureUsage + (DEFAULT_VERSION_VALUE.equals(javaVersion) ? "" : ", java/" + javaVersion) + (DEFAULT_VERSION_VALUE.equals(androidVersion) ? "" : ", android/" + androidVersion);
        telemetryAddedBuilder.addHeader(SDK_VERSION, sdkversion_value);
        if (request.header(CLIENT_REQUEST_ID) == null) {
            telemetryAddedBuilder.addHeader(CLIENT_REQUEST_ID, telemetryOptions.getClientRequestId());
        }
        return chain.proceed(telemetryAddedBuilder.build());
    }

    private String getAndroidAPILevel() {
        if (this.androidAPILevel == null) {
            this.androidAPILevel = this.getAndroidAPILevelInternal();
        }
        return this.androidAPILevel;
    }

    private String getAndroidAPILevelInternal() {
        try {
            Class<?> buildClass = Class.forName("android.os.Build");
            Class<?>[] subclasses = buildClass.getDeclaredClasses();
            Class<?> versionClass = null;
            for (Class<?> subclass : subclasses) {
                if (!subclass.getName().endsWith("VERSION")) continue;
                versionClass = subclass;
                break;
            }
            if (versionClass == null) {
                return DEFAULT_VERSION_VALUE;
            }
            Field sdkVersionField = versionClass.getField("SDK_INT");
            Object value = sdkVersionField.get(null);
            String valueStr = String.valueOf(value);
            return valueStr == null || valueStr.equals("") ? DEFAULT_VERSION_VALUE : valueStr;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            return DEFAULT_VERSION_VALUE;
        }
    }
}

