/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.JsonElement;
import com.microsoft.graph.logger.ILogger;
import java.math.BigDecimal;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EdmNativeTypeSerializer {
    @Nullable
    public static <T> T deserialize(@Nonnull JsonElement json, @Nonnull Class<T> type, @Nonnull ILogger logger) {
        if (json == null || type == null) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            return EdmNativeTypeSerializer.getPrimitiveValue(json, type);
        }
        if (json.isJsonObject()) {
            JsonElement element = json.getAsJsonObject().get("@odata.null");
            if (element != null && element.isJsonPrimitive()) {
                return EdmNativeTypeSerializer.getPrimitiveValue(element, type);
            }
            return null;
        }
        return null;
    }

    private static <T> T getPrimitiveValue(JsonElement json, Class<T> type) {
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(json.getAsBoolean());
        }
        if (type == String.class) {
            return (T)json.getAsString();
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(json.getAsInt());
        }
        if (type == UUID.class) {
            return (T)UUID.fromString(json.getAsString());
        }
        if (type == Long.class) {
            return (T)Long.valueOf(json.getAsLong());
        }
        if (type == Float.class) {
            return (T)Float.valueOf(json.getAsFloat());
        }
        if (type == BigDecimal.class) {
            return (T)json.getAsBigDecimal();
        }
        return null;
    }
}

