/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.httpcore.AuthenticationHandler;
import com.microsoft.graph.httpcore.RedirectHandler;
import com.microsoft.graph.httpcore.RetryHandler;
import com.microsoft.graph.httpcore.TelemetryHandler;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class HttpClients {
    private HttpClients() {
    }

    @Nonnull
    public static OkHttpClient.Builder custom() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new TelemetryHandler()).followRedirects(false).followSslRedirects(false).protocols(Collections.singletonList(Protocol.HTTP_1_1));
    }

    @Nonnull
    public static OkHttpClient createDefault(@Nonnull IAuthenticationProvider auth) {
        Objects.requireNonNull(auth, "parameter auth cannot be null");
        return HttpClients.custom().addInterceptor((Interceptor)new AuthenticationHandler(auth)).addInterceptor((Interceptor)new RetryHandler()).addInterceptor((Interceptor)new RedirectHandler()).build();
    }

    @Nonnull
    public static OkHttpClient createFromInterceptors(@Nullable Interceptor[] interceptors) {
        OkHttpClient.Builder builder = HttpClients.custom();
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        return builder.build();
    }
}

