/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.AuthenticationHandler;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import com.microsoft.graph.httpcore.RedirectHandler;
import com.microsoft.graph.httpcore.RetryHandler;
import com.microsoft.graph.httpcore.TelemetryHandler;
import java.util.Arrays;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class HttpClients {
    private HttpClients() {
    }

    public static OkHttpClient.Builder custom() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new TelemetryHandler()).followRedirects(false).followSslRedirects(false).protocols(Arrays.asList(Protocol.HTTP_1_1));
    }

    public static OkHttpClient createDefault(ICoreAuthenticationProvider auth) {
        return HttpClients.custom().addInterceptor((Interceptor)new AuthenticationHandler(auth)).addInterceptor((Interceptor)new RetryHandler()).addInterceptor((Interceptor)new RedirectHandler()).build();
    }

    public static OkHttpClient createFromInterceptors(Interceptor[] interceptors) {
        OkHttpClient.Builder builder = HttpClients.custom();
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        return builder.build();
    }
}

