/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.content.MSBatchRequestStep;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class MSBatchRequestContent {
    private final LinkedHashMap<String, MSBatchRequestStep> batchRequestStepsHashMap;
    public static final int MAX_NUMBER_OF_REQUESTS = 20;

    public MSBatchRequestContent(List<MSBatchRequestStep> batchRequestStepsArray) {
        if (batchRequestStepsArray.size() > 20) {
            throw new IllegalArgumentException("Number of batch request steps cannot exceed 20");
        }
        this.batchRequestStepsHashMap = new LinkedHashMap();
        for (MSBatchRequestStep requestStep : batchRequestStepsArray) {
            this.addBatchRequestStep(requestStep);
        }
    }

    public MSBatchRequestContent() {
        this.batchRequestStepsHashMap = new LinkedHashMap();
    }

    public boolean addBatchRequestStep(MSBatchRequestStep batchRequestStep) {
        if (this.batchRequestStepsHashMap.containsKey(batchRequestStep.getRequestId()) || this.batchRequestStepsHashMap.size() >= 20) {
            return false;
        }
        this.batchRequestStepsHashMap.put(batchRequestStep.getRequestId(), batchRequestStep);
        return true;
    }

    public String addBatchRequestStep(Request request, String ... arrayOfDependsOnIds) {
        String requestId;
        do {
            requestId = Integer.toString(ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE));
        } while (this.batchRequestStepsHashMap.keySet().contains(requestId));
        if (this.addBatchRequestStep(new MSBatchRequestStep(requestId, request, Arrays.asList(arrayOfDependsOnIds)))) {
            return requestId;
        }
        throw new IllegalArgumentException("unable to add step to batch. Number of batch request steps cannot exceed 20");
    }

    public boolean removeBatchRequestStepWithId(String requestId) {
        boolean removed = false;
        if (this.batchRequestStepsHashMap.containsKey(requestId)) {
            this.batchRequestStepsHashMap.remove(requestId);
            removed = true;
            for (Map.Entry<String, MSBatchRequestStep> steps : this.batchRequestStepsHashMap.entrySet()) {
                if (steps.getValue() == null || steps.getValue().getArrayOfDependsOnIds() == null) continue;
                while (steps.getValue().getArrayOfDependsOnIds().remove(requestId)) {
                }
            }
        }
        return removed;
    }

    public String getBatchRequestContent() {
        JsonObject batchRequestContentMap = new JsonObject();
        JsonArray batchContentArray = new JsonArray();
        for (Map.Entry<String, MSBatchRequestStep> requestStep : this.batchRequestStepsHashMap.entrySet()) {
            batchContentArray.add((JsonElement)this.getBatchRequestObjectFromRequestStep(requestStep.getValue()));
        }
        batchRequestContentMap.add("requests", (JsonElement)batchContentArray);
        String content = batchRequestContentMap.toString();
        return content;
    }

    private JsonObject getBatchRequestObjectFromRequestStep(MSBatchRequestStep batchRequestStep) {
        RequestBody body;
        List<String> arrayOfDependsOnIds;
        JsonObject contentmap = new JsonObject();
        contentmap.add("id", (JsonElement)new JsonPrimitive(batchRequestStep.getRequestId()));
        String url = batchRequestStep.getRequest().url().toString().replaceAll("https://graph.microsoft.com/v1.0/", "").replaceAll("http://graph.microsoft.com/v1.0/", "").replaceAll("https://graph.microsoft.com/beta/", "").replaceAll("http://graph.microsoft.com/beta/", "");
        contentmap.add("url", (JsonElement)new JsonPrimitive(url));
        contentmap.add("method", (JsonElement)new JsonPrimitive(batchRequestStep.getRequest().method().toString()));
        Headers headers = batchRequestStep.getRequest().headers();
        if (headers != null && headers.size() != 0) {
            JsonObject headerMap = new JsonObject();
            for (Map.Entry entry : headers.toMultimap().entrySet()) {
                headerMap.add((String)entry.getKey(), (JsonElement)new JsonPrimitive(this.getHeaderValuesAsString((List)entry.getValue())));
            }
            contentmap.add("headers", (JsonElement)headerMap);
        }
        if ((arrayOfDependsOnIds = batchRequestStep.getArrayOfDependsOnIds()) != null) {
            JsonArray array = new JsonArray();
            for (String dependsOnId : arrayOfDependsOnIds) {
                array.add(dependsOnId);
            }
            contentmap.add("dependsOn", (JsonElement)array);
        }
        if ((body = batchRequestStep.getRequest().body()) != null) {
            try {
                contentmap.add("body", (JsonElement)this.requestBodyToJSONObject(batchRequestStep.getRequest()));
            }
            catch (JsonParseException | IOException throwable) {
                throwable.printStackTrace();
            }
        }
        return contentmap;
    }

    private String getHeaderValuesAsString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            builder.append(";");
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    private JsonObject requestBodyToJSONObject(Request request) throws IOException, JsonParseException {
        if (request == null || request.body() == null) {
            return null;
        }
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        copy.body().writeTo((BufferedSink)buffer);
        String requestBody = buffer.readUtf8();
        if (requestBody == null || requestBody == "") {
            return null;
        }
        JsonElement requestBodyElement = JsonParser.parseString((String)requestBody);
        if (requestBodyElement == null || !requestBodyElement.isJsonObject()) {
            return null;
        }
        return requestBodyElement.getAsJsonObject();
    }
}

