package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

/**
 * Device app management task mitigation type.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public enum AppVulnerabilityTaskMitigationType implements ValuedEnum {
    /** Mitigation steps are unknown. */
    Unknown("unknown"),
    /** The app needs to be updated. */
    Update("update"),
    /** The app needs to be uninstalled. */
    Uninstall("uninstall"),
    /** The security configuration needs to be changed. */
    SecurityConfiguration("securityConfiguration");
    public final String value;
    AppVulnerabilityTaskMitigationType(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static AppVulnerabilityTaskMitigationType forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "unknown": return Unknown;
            case "update": return Update;
            case "uninstall": return Uninstall;
            case "securityConfiguration": return SecurityConfiguration;
            default: return null;
        }
    }
}
