package com.microsoft.graph.beta.models.networkaccess;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

@jakarta.annotation.Generated("com.microsoft.kiota")
public enum MalwareCategory implements ValuedEnum {
    Adware("adware"),
    Backdoor("backdoor"),
    Behavior("behavior"),
    Bot("bot"),
    BrowserModifier("browserModifier"),
    Constructor("constructor"),
    Cryptojacking("cryptojacking"),
    Ddos("ddos"),
    Dropper("dropper"),
    DropperMalware("dropperMalware"),
    Exploit("exploit"),
    FilelessMalware("filelessMalware"),
    HackTool("hackTool"),
    HybridMalware("hybridMalware"),
    Joke("joke"),
    Keylogger("keylogger"),
    Misleading("misleading"),
    MonitoringTool("monitoringTool"),
    PolymorphicMalware("polymorphicMalware"),
    PasswordStealer("passwordStealer"),
    Program("program"),
    Ransomware("ransomware"),
    RemoteAccess("remoteAccess"),
    Rogue("rogue"),
    Rootkit("rootkit"),
    SettingsModifier("settingsModifier"),
    SoftwareBundler("softwareBundler"),
    Spammer("spammer"),
    Spoofer("spoofer"),
    Spyware("spyware"),
    Tool("tool"),
    Trojan("trojan"),
    TrojanClicker("trojanClicker"),
    TrojanDownloader("trojanDownloader"),
    TrojanNotifier("trojanNotifier"),
    TrojanProxy("trojanProxy"),
    TrojanSpy("trojanSpy"),
    Virus("virus"),
    WiperMalware("wiperMalware"),
    Worm("worm"),
    UnknownFutureValue("unknownFutureValue");
    public final String value;
    MalwareCategory(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static MalwareCategory forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "adware": return Adware;
            case "backdoor": return Backdoor;
            case "behavior": return Behavior;
            case "bot": return Bot;
            case "browserModifier": return BrowserModifier;
            case "constructor": return Constructor;
            case "cryptojacking": return Cryptojacking;
            case "ddos": return Ddos;
            case "dropper": return Dropper;
            case "dropperMalware": return DropperMalware;
            case "exploit": return Exploit;
            case "filelessMalware": return FilelessMalware;
            case "hackTool": return HackTool;
            case "hybridMalware": return HybridMalware;
            case "joke": return Joke;
            case "keylogger": return Keylogger;
            case "misleading": return Misleading;
            case "monitoringTool": return MonitoringTool;
            case "polymorphicMalware": return PolymorphicMalware;
            case "passwordStealer": return PasswordStealer;
            case "program": return Program;
            case "ransomware": return Ransomware;
            case "remoteAccess": return RemoteAccess;
            case "rogue": return Rogue;
            case "rootkit": return Rootkit;
            case "settingsModifier": return SettingsModifier;
            case "softwareBundler": return SoftwareBundler;
            case "spammer": return Spammer;
            case "spoofer": return Spoofer;
            case "spyware": return Spyware;
            case "tool": return Tool;
            case "trojan": return Trojan;
            case "trojanClicker": return TrojanClicker;
            case "trojanDownloader": return TrojanDownloader;
            case "trojanNotifier": return TrojanNotifier;
            case "trojanProxy": return TrojanProxy;
            case "trojanSpy": return TrojanSpy;
            case "virus": return Virus;
            case "wiperMalware": return WiperMalware;
            case "worm": return Worm;
            case "unknownFutureValue": return UnknownFutureValue;
            default: return null;
        }
    }
}
