package com.microsoft.graph.beta.models.managedtenants;

import com.microsoft.graph.beta.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class WindowsDeviceMalwareState extends Entity implements Parsable {
    /**
     * Instantiates a new {@link WindowsDeviceMalwareState} and sets the default values.
     */
    public WindowsDeviceMalwareState() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link WindowsDeviceMalwareState}
     */
    @jakarta.annotation.Nonnull
    public static WindowsDeviceMalwareState createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsDeviceMalwareState();
    }
    /**
     * Gets the additionalInformationUrl property value. The additional information URL for the discovered malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getAdditionalInformationUrl() {
        return this.backingStore.get("additionalInformationUrl");
    }
    /**
     * Gets the detectionCount property value. The number of times the piece of malware has been detected. Optional. Read-only.
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getDetectionCount() {
        return this.backingStore.get("detectionCount");
    }
    /**
     * Gets the deviceDeleted property value. A flag indicating whether the device has been deleted. Optional. Read-only.
     * @return a {@link Boolean}
     */
    @jakarta.annotation.Nullable
    public Boolean getDeviceDeleted() {
        return this.backingStore.get("deviceDeleted");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalInformationUrl", (n) -> { this.setAdditionalInformationUrl(n.getStringValue()); });
        deserializerMap.put("detectionCount", (n) -> { this.setDetectionCount(n.getIntegerValue()); });
        deserializerMap.put("deviceDeleted", (n) -> { this.setDeviceDeleted(n.getBooleanValue()); });
        deserializerMap.put("initialDetectionDateTime", (n) -> { this.setInitialDetectionDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastRefreshedDateTime", (n) -> { this.setLastRefreshedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastStateChangeDateTime", (n) -> { this.setLastStateChangeDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("malwareCategory", (n) -> { this.setMalwareCategory(n.getStringValue()); });
        deserializerMap.put("malwareDisplayName", (n) -> { this.setMalwareDisplayName(n.getStringValue()); });
        deserializerMap.put("malwareExecutionState", (n) -> { this.setMalwareExecutionState(n.getStringValue()); });
        deserializerMap.put("malwareId", (n) -> { this.setMalwareId(n.getStringValue()); });
        deserializerMap.put("malwareSeverity", (n) -> { this.setMalwareSeverity(n.getStringValue()); });
        deserializerMap.put("malwareThreatState", (n) -> { this.setMalwareThreatState(n.getStringValue()); });
        deserializerMap.put("managedDeviceId", (n) -> { this.setManagedDeviceId(n.getStringValue()); });
        deserializerMap.put("managedDeviceName", (n) -> { this.setManagedDeviceName(n.getStringValue()); });
        deserializerMap.put("tenantDisplayName", (n) -> { this.setTenantDisplayName(n.getStringValue()); });
        deserializerMap.put("tenantId", (n) -> { this.setTenantId(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the initialDetectionDateTime property value. The date and time the piece of malware was initially detected. Optional. Read-only.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getInitialDetectionDateTime() {
        return this.backingStore.get("initialDetectionDateTime");
    }
    /**
     * Gets the lastRefreshedDateTime property value. Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastRefreshedDateTime() {
        return this.backingStore.get("lastRefreshedDateTime");
    }
    /**
     * Gets the lastStateChangeDateTime property value. The date and time the malware state was last changed. Optional. Read-only.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastStateChangeDateTime() {
        return this.backingStore.get("lastStateChangeDateTime");
    }
    /**
     * Gets the malwareCategory property value. The category for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareCategory() {
        return this.backingStore.get("malwareCategory");
    }
    /**
     * Gets the malwareDisplayName property value. The display name for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareDisplayName() {
        return this.backingStore.get("malwareDisplayName");
    }
    /**
     * Gets the malwareExecutionState property value. The execution state for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareExecutionState() {
        return this.backingStore.get("malwareExecutionState");
    }
    /**
     * Gets the malwareId property value. The unique identifier for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareId() {
        return this.backingStore.get("malwareId");
    }
    /**
     * Gets the malwareSeverity property value. The severity for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareSeverity() {
        return this.backingStore.get("malwareSeverity");
    }
    /**
     * Gets the malwareThreatState property value. The threat state for the detected malware. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMalwareThreatState() {
        return this.backingStore.get("malwareThreatState");
    }
    /**
     * Gets the managedDeviceId property value. The identifier for the managed device where the malware was detected. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getManagedDeviceId() {
        return this.backingStore.get("managedDeviceId");
    }
    /**
     * Gets the managedDeviceName property value. The display name for the managed device where the malware was detected. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getManagedDeviceName() {
        return this.backingStore.get("managedDeviceName");
    }
    /**
     * Gets the tenantDisplayName property value. The display name for the managed tenant. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getTenantDisplayName() {
        return this.backingStore.get("tenantDisplayName");
    }
    /**
     * Gets the tenantId property value. The Microsoft Entra tenant identifier for the managed tenant. Optional. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getTenantId() {
        return this.backingStore.get("tenantId");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("additionalInformationUrl", this.getAdditionalInformationUrl());
        writer.writeIntegerValue("detectionCount", this.getDetectionCount());
        writer.writeBooleanValue("deviceDeleted", this.getDeviceDeleted());
        writer.writeOffsetDateTimeValue("initialDetectionDateTime", this.getInitialDetectionDateTime());
        writer.writeOffsetDateTimeValue("lastRefreshedDateTime", this.getLastRefreshedDateTime());
        writer.writeOffsetDateTimeValue("lastStateChangeDateTime", this.getLastStateChangeDateTime());
        writer.writeStringValue("malwareCategory", this.getMalwareCategory());
        writer.writeStringValue("malwareDisplayName", this.getMalwareDisplayName());
        writer.writeStringValue("malwareExecutionState", this.getMalwareExecutionState());
        writer.writeStringValue("malwareId", this.getMalwareId());
        writer.writeStringValue("malwareSeverity", this.getMalwareSeverity());
        writer.writeStringValue("malwareThreatState", this.getMalwareThreatState());
        writer.writeStringValue("managedDeviceId", this.getManagedDeviceId());
        writer.writeStringValue("managedDeviceName", this.getManagedDeviceName());
        writer.writeStringValue("tenantDisplayName", this.getTenantDisplayName());
        writer.writeStringValue("tenantId", this.getTenantId());
    }
    /**
     * Sets the additionalInformationUrl property value. The additional information URL for the discovered malware. Optional. Read-only.
     * @param value Value to set for the additionalInformationUrl property.
     */
    public void setAdditionalInformationUrl(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("additionalInformationUrl", value);
    }
    /**
     * Sets the detectionCount property value. The number of times the piece of malware has been detected. Optional. Read-only.
     * @param value Value to set for the detectionCount property.
     */
    public void setDetectionCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("detectionCount", value);
    }
    /**
     * Sets the deviceDeleted property value. A flag indicating whether the device has been deleted. Optional. Read-only.
     * @param value Value to set for the deviceDeleted property.
     */
    public void setDeviceDeleted(@jakarta.annotation.Nullable final Boolean value) {
        this.backingStore.set("deviceDeleted", value);
    }
    /**
     * Sets the initialDetectionDateTime property value. The date and time the piece of malware was initially detected. Optional. Read-only.
     * @param value Value to set for the initialDetectionDateTime property.
     */
    public void setInitialDetectionDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("initialDetectionDateTime", value);
    }
    /**
     * Sets the lastRefreshedDateTime property value. Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
     * @param value Value to set for the lastRefreshedDateTime property.
     */
    public void setLastRefreshedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastRefreshedDateTime", value);
    }
    /**
     * Sets the lastStateChangeDateTime property value. The date and time the malware state was last changed. Optional. Read-only.
     * @param value Value to set for the lastStateChangeDateTime property.
     */
    public void setLastStateChangeDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastStateChangeDateTime", value);
    }
    /**
     * Sets the malwareCategory property value. The category for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareCategory property.
     */
    public void setMalwareCategory(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareCategory", value);
    }
    /**
     * Sets the malwareDisplayName property value. The display name for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareDisplayName property.
     */
    public void setMalwareDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareDisplayName", value);
    }
    /**
     * Sets the malwareExecutionState property value. The execution state for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareExecutionState property.
     */
    public void setMalwareExecutionState(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareExecutionState", value);
    }
    /**
     * Sets the malwareId property value. The unique identifier for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareId property.
     */
    public void setMalwareId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareId", value);
    }
    /**
     * Sets the malwareSeverity property value. The severity for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareSeverity property.
     */
    public void setMalwareSeverity(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareSeverity", value);
    }
    /**
     * Sets the malwareThreatState property value. The threat state for the detected malware. Optional. Read-only.
     * @param value Value to set for the malwareThreatState property.
     */
    public void setMalwareThreatState(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("malwareThreatState", value);
    }
    /**
     * Sets the managedDeviceId property value. The identifier for the managed device where the malware was detected. Optional. Read-only.
     * @param value Value to set for the managedDeviceId property.
     */
    public void setManagedDeviceId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("managedDeviceId", value);
    }
    /**
     * Sets the managedDeviceName property value. The display name for the managed device where the malware was detected. Optional. Read-only.
     * @param value Value to set for the managedDeviceName property.
     */
    public void setManagedDeviceName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("managedDeviceName", value);
    }
    /**
     * Sets the tenantDisplayName property value. The display name for the managed tenant. Optional. Read-only.
     * @param value Value to set for the tenantDisplayName property.
     */
    public void setTenantDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("tenantDisplayName", value);
    }
    /**
     * Sets the tenantId property value. The Microsoft Entra tenant identifier for the managed tenant. Optional. Read-only.
     * @param value Value to set for the tenantId property.
     */
    public void setTenantId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("tenantId", value);
    }
}
