package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * An app vulnerability mobile app.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class AppVulnerabilityMobileApp extends Entity implements Parsable {
    /**
     * Instantiates a new {@link AppVulnerabilityMobileApp} and sets the default values.
     */
    public AppVulnerabilityMobileApp() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link AppVulnerabilityMobileApp}
     */
    @jakarta.annotation.Nonnull
    public static AppVulnerabilityMobileApp createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AppVulnerabilityMobileApp();
    }
    /**
     * Gets the createdDateTime property value. The created date.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getCreatedDateTime() {
        return this.backingStore.get("createdDateTime");
    }
    /**
     * Gets the displayName property value. The device name.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getDisplayName() {
        return this.backingStore.get("displayName");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", (n) -> { this.setCreatedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("displayName", (n) -> { this.setDisplayName(n.getStringValue()); });
        deserializerMap.put("lastModifiedDateTime", (n) -> { this.setLastModifiedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("mobileAppId", (n) -> { this.setMobileAppId(n.getStringValue()); });
        deserializerMap.put("mobileAppType", (n) -> { this.setMobileAppType(n.getStringValue()); });
        deserializerMap.put("version", (n) -> { this.setVersion(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the lastModifiedDateTime property value. The last modified date.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return this.backingStore.get("lastModifiedDateTime");
    }
    /**
     * Gets the mobileAppId property value. The Intune mobile app ID.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMobileAppId() {
        return this.backingStore.get("mobileAppId");
    }
    /**
     * Gets the mobileAppType property value. The app type.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getMobileAppType() {
        return this.backingStore.get("mobileAppType");
    }
    /**
     * Gets the version property value. The app version.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getVersion() {
        return this.backingStore.get("version");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("mobileAppId", this.getMobileAppId());
        writer.writeStringValue("mobileAppType", this.getMobileAppType());
        writer.writeStringValue("version", this.getVersion());
    }
    /**
     * Sets the createdDateTime property value. The created date.
     * @param value Value to set for the createdDateTime property.
     */
    public void setCreatedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("createdDateTime", value);
    }
    /**
     * Sets the displayName property value. The device name.
     * @param value Value to set for the displayName property.
     */
    public void setDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("displayName", value);
    }
    /**
     * Sets the lastModifiedDateTime property value. The last modified date.
     * @param value Value to set for the lastModifiedDateTime property.
     */
    public void setLastModifiedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", value);
    }
    /**
     * Sets the mobileAppId property value. The Intune mobile app ID.
     * @param value Value to set for the mobileAppId property.
     */
    public void setMobileAppId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("mobileAppId", value);
    }
    /**
     * Sets the mobileAppType property value. The app type.
     * @param value Value to set for the mobileAppType property.
     */
    public void setMobileAppType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("mobileAppType", value);
    }
    /**
     * Sets the version property value. The app version.
     * @param value Value to set for the version property.
     */
    public void setVersion(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("version", value);
    }
}
