package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Windows device malware overview.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class WindowsMalwareOverview implements AdditionalDataHolder, BackedModel, Parsable {
    /**
     * Stores model information.
     */
    @jakarta.annotation.Nonnull
    protected BackingStore backingStore;
    /**
     * Instantiates a new {@link WindowsMalwareOverview} and sets the default values.
     */
    public WindowsMalwareOverview() {
        this.backingStore = BackingStoreFactorySingleton.instance.createBackingStore();
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link WindowsMalwareOverview}
     */
    @jakarta.annotation.Nonnull
    public static WindowsMalwareOverview createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareOverview();
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a {@link Map<String, Object>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        Map<String, Object> value = this.backingStore.get("additionalData");
        if(value == null) {
            value = new HashMap<>();
            this.setAdditionalData(value);
        }
        return value;
    }
    /**
     * Gets the backingStore property value. Stores model information.
     * @return a {@link BackingStore}
     */
    @jakarta.annotation.Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(10);
        deserializerMap.put("malwareCategorySummary", (n) -> { this.setMalwareCategorySummary(n.getCollectionOfObjectValues(WindowsMalwareCategoryCount::createFromDiscriminatorValue)); });
        deserializerMap.put("malwareDetectedDeviceCount", (n) -> { this.setMalwareDetectedDeviceCount(n.getIntegerValue()); });
        deserializerMap.put("malwareExecutionStateSummary", (n) -> { this.setMalwareExecutionStateSummary(n.getCollectionOfObjectValues(WindowsMalwareExecutionStateCount::createFromDiscriminatorValue)); });
        deserializerMap.put("malwareNameSummary", (n) -> { this.setMalwareNameSummary(n.getCollectionOfObjectValues(WindowsMalwareNameCount::createFromDiscriminatorValue)); });
        deserializerMap.put("malwareSeveritySummary", (n) -> { this.setMalwareSeveritySummary(n.getCollectionOfObjectValues(WindowsMalwareSeverityCount::createFromDiscriminatorValue)); });
        deserializerMap.put("malwareStateSummary", (n) -> { this.setMalwareStateSummary(n.getCollectionOfObjectValues(WindowsMalwareStateCount::createFromDiscriminatorValue)); });
        deserializerMap.put("@odata.type", (n) -> { this.setOdataType(n.getStringValue()); });
        deserializerMap.put("osVersionsSummary", (n) -> { this.setOsVersionsSummary(n.getCollectionOfObjectValues(OsVersionCount::createFromDiscriminatorValue)); });
        deserializerMap.put("totalDistinctMalwareCount", (n) -> { this.setTotalDistinctMalwareCount(n.getIntegerValue()); });
        deserializerMap.put("totalMalwareCount", (n) -> { this.setTotalMalwareCount(n.getIntegerValue()); });
        return deserializerMap;
    }
    /**
     * Gets the malwareCategorySummary property value. List of device counts per malware category
     * @return a {@link java.util.List<WindowsMalwareCategoryCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<WindowsMalwareCategoryCount> getMalwareCategorySummary() {
        return this.backingStore.get("malwareCategorySummary");
    }
    /**
     * Gets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getMalwareDetectedDeviceCount() {
        return this.backingStore.get("malwareDetectedDeviceCount");
    }
    /**
     * Gets the malwareExecutionStateSummary property value. List of device counts per malware execution state
     * @return a {@link java.util.List<WindowsMalwareExecutionStateCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<WindowsMalwareExecutionStateCount> getMalwareExecutionStateSummary() {
        return this.backingStore.get("malwareExecutionStateSummary");
    }
    /**
     * Gets the malwareNameSummary property value. List of device counts per malware
     * @return a {@link java.util.List<WindowsMalwareNameCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<WindowsMalwareNameCount> getMalwareNameSummary() {
        return this.backingStore.get("malwareNameSummary");
    }
    /**
     * Gets the malwareSeveritySummary property value. List of active malware counts per malware severity
     * @return a {@link java.util.List<WindowsMalwareSeverityCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<WindowsMalwareSeverityCount> getMalwareSeveritySummary() {
        return this.backingStore.get("malwareSeveritySummary");
    }
    /**
     * Gets the malwareStateSummary property value. List of device counts per malware state
     * @return a {@link java.util.List<WindowsMalwareStateCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<WindowsMalwareStateCount> getMalwareStateSummary() {
        return this.backingStore.get("malwareStateSummary");
    }
    /**
     * Gets the @odata.type property value. The OdataType property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getOdataType() {
        return this.backingStore.get("odataType");
    }
    /**
     * Gets the osVersionsSummary property value. List of device counts with malware per windows OS version
     * @return a {@link java.util.List<OsVersionCount>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<OsVersionCount> getOsVersionsSummary() {
        return this.backingStore.get("osVersionsSummary");
    }
    /**
     * Gets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getTotalDistinctMalwareCount() {
        return this.backingStore.get("totalDistinctMalwareCount");
    }
    /**
     * Gets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getTotalMalwareCount() {
        return this.backingStore.get("totalMalwareCount");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("malwareCategorySummary", this.getMalwareCategorySummary());
        writer.writeIntegerValue("malwareDetectedDeviceCount", this.getMalwareDetectedDeviceCount());
        writer.writeCollectionOfObjectValues("malwareExecutionStateSummary", this.getMalwareExecutionStateSummary());
        writer.writeCollectionOfObjectValues("malwareNameSummary", this.getMalwareNameSummary());
        writer.writeCollectionOfObjectValues("malwareSeveritySummary", this.getMalwareSeveritySummary());
        writer.writeCollectionOfObjectValues("malwareStateSummary", this.getMalwareStateSummary());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("osVersionsSummary", this.getOsVersionsSummary());
        writer.writeIntegerValue("totalDistinctMalwareCount", this.getTotalDistinctMalwareCount());
        writer.writeIntegerValue("totalMalwareCount", this.getTotalMalwareCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }
    /**
     * Sets the backingStore property value. Stores model information.
     * @param value Value to set for the backingStore property.
     */
    public void setBackingStore(@jakarta.annotation.Nonnull final BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }
    /**
     * Sets the malwareCategorySummary property value. List of device counts per malware category
     * @param value Value to set for the malwareCategorySummary property.
     */
    public void setMalwareCategorySummary(@jakarta.annotation.Nullable final java.util.List<WindowsMalwareCategoryCount> value) {
        this.backingStore.set("malwareCategorySummary", value);
    }
    /**
     * Sets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
     * @param value Value to set for the malwareDetectedDeviceCount property.
     */
    public void setMalwareDetectedDeviceCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("malwareDetectedDeviceCount", value);
    }
    /**
     * Sets the malwareExecutionStateSummary property value. List of device counts per malware execution state
     * @param value Value to set for the malwareExecutionStateSummary property.
     */
    public void setMalwareExecutionStateSummary(@jakarta.annotation.Nullable final java.util.List<WindowsMalwareExecutionStateCount> value) {
        this.backingStore.set("malwareExecutionStateSummary", value);
    }
    /**
     * Sets the malwareNameSummary property value. List of device counts per malware
     * @param value Value to set for the malwareNameSummary property.
     */
    public void setMalwareNameSummary(@jakarta.annotation.Nullable final java.util.List<WindowsMalwareNameCount> value) {
        this.backingStore.set("malwareNameSummary", value);
    }
    /**
     * Sets the malwareSeveritySummary property value. List of active malware counts per malware severity
     * @param value Value to set for the malwareSeveritySummary property.
     */
    public void setMalwareSeveritySummary(@jakarta.annotation.Nullable final java.util.List<WindowsMalwareSeverityCount> value) {
        this.backingStore.set("malwareSeveritySummary", value);
    }
    /**
     * Sets the malwareStateSummary property value. List of device counts per malware state
     * @param value Value to set for the malwareStateSummary property.
     */
    public void setMalwareStateSummary(@jakarta.annotation.Nullable final java.util.List<WindowsMalwareStateCount> value) {
        this.backingStore.set("malwareStateSummary", value);
    }
    /**
     * Sets the @odata.type property value. The OdataType property
     * @param value Value to set for the @odata.type property.
     */
    public void setOdataType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("odataType", value);
    }
    /**
     * Sets the osVersionsSummary property value. List of device counts with malware per windows OS version
     * @param value Value to set for the osVersionsSummary property.
     */
    public void setOsVersionsSummary(@jakarta.annotation.Nullable final java.util.List<OsVersionCount> value) {
        this.backingStore.set("osVersionsSummary", value);
    }
    /**
     * Sets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
     * @param value Value to set for the totalDistinctMalwareCount property.
     */
    public void setTotalDistinctMalwareCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("totalDistinctMalwareCount", value);
    }
    /**
     * Sets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
     * @param value Value to set for the totalMalwareCount property.
     */
    public void setTotalMalwareCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("totalMalwareCount", value);
    }
}
