/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.requests.resolvers;

import com.microsoft.walletlibrary.requests.handlers.OpenIdRequestHandler;
import com.microsoft.walletlibrary.requests.handlers.RequestHandler;
import com.microsoft.walletlibrary.requests.input.VerifiedIdRequestInput;
import com.microsoft.walletlibrary.requests.input.VerifiedIdRequestURL;
import com.microsoft.walletlibrary.requests.rawrequests.OpenIdRawRequest;
import com.microsoft.walletlibrary.requests.resolvers.RequestResolver;
import com.microsoft.walletlibrary.util.UnSupportedVerifiedIdRequestInputException;
import com.microsoft.walletlibrary.wrapper.OpenIdResolver;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lcom/microsoft/walletlibrary/requests/resolvers/OpenIdURLRequestResolver;", "Lcom/microsoft/walletlibrary/requests/resolvers/RequestResolver;", "()V", "canResolve", "", "requestHandler", "Lcom/microsoft/walletlibrary/requests/handlers/RequestHandler;", "verifiedIdRequestInput", "Lcom/microsoft/walletlibrary/requests/input/VerifiedIdRequestInput;", "resolve", "Lcom/microsoft/walletlibrary/requests/rawrequests/OpenIdRawRequest;", "(Lcom/microsoft/walletlibrary/requests/input/VerifiedIdRequestInput;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public final class OpenIdURLRequestResolver
implements RequestResolver {
    @Override
    public boolean canResolve(@NotNull RequestHandler requestHandler) {
        Intrinsics.checkNotNullParameter((Object)requestHandler, (String)"requestHandler");
        return requestHandler instanceof OpenIdRequestHandler;
    }

    @Override
    public boolean canResolve(@NotNull VerifiedIdRequestInput verifiedIdRequestInput) {
        Intrinsics.checkNotNullParameter((Object)verifiedIdRequestInput, (String)"verifiedIdRequestInput");
        if (!(verifiedIdRequestInput instanceof VerifiedIdRequestURL)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((VerifiedIdRequestURL)verifiedIdRequestInput).getUrl$walletlibrary_release().getScheme(), (Object)"openid-vc");
    }

    @Nullable
    public Object resolve(@NotNull VerifiedIdRequestInput verifiedIdRequestInput, @NotNull Continuation<? super OpenIdRawRequest> $completion) {
        if (!(verifiedIdRequestInput instanceof VerifiedIdRequestURL)) {
            throw new UnSupportedVerifiedIdRequestInputException("Provided VerifiedIdRequestInput is not supported.", null, false, 6, null);
        }
        String string = ((VerifiedIdRequestURL)verifiedIdRequestInput).getUrl$walletlibrary_release().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"verifiedIdRequestInput.url.toString()");
        return OpenIdResolver.INSTANCE.getRequest$walletlibrary_release(string, $completion);
    }
}

