/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.requests.requirements.constraints;

import com.microsoft.walletlibrary.requests.requirements.constraints.VerifiedIdConstraint;
import com.microsoft.walletlibrary.util.VerifiedIdTypeIsNotRequestedTypeException;
import com.microsoft.walletlibrary.verifiedid.VerifiableCredential;
import com.microsoft.walletlibrary.verifiedid.VerifiedId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/microsoft/walletlibrary/requests/requirements/constraints/VcTypeConstraint;", "Lcom/microsoft/walletlibrary/requests/requirements/constraints/VerifiedIdConstraint;", "vcType", "", "(Ljava/lang/String;)V", "getVcType$walletlibrary_release", "()Ljava/lang/String;", "doesMatch", "", "verifiedId", "Lcom/microsoft/walletlibrary/verifiedid/VerifiedId;", "matches", "", "walletlibrary_release"})
public final class VcTypeConstraint
implements VerifiedIdConstraint {
    @NotNull
    private final String vcType;

    public VcTypeConstraint(@NotNull String vcType) {
        Intrinsics.checkNotNullParameter((Object)vcType, (String)"vcType");
        this.vcType = vcType;
    }

    @NotNull
    public final String getVcType$walletlibrary_release() {
        return this.vcType;
    }

    @Override
    public boolean doesMatch(@NotNull VerifiedId verifiedId) {
        Intrinsics.checkNotNullParameter((Object)verifiedId, (String)"verifiedId");
        if (!(verifiedId instanceof VerifiableCredential)) {
            return false;
        }
        return ((VerifiableCredential)verifiedId).getTypes().contains(this.vcType);
    }

    @Override
    public void matches(@NotNull VerifiedId verifiedId) {
        Intrinsics.checkNotNullParameter((Object)verifiedId, (String)"verifiedId");
        if (!this.doesMatch(verifiedId)) {
            throw new VerifiedIdTypeIsNotRequestedTypeException("Provided Verified Id type does not match requested type " + this.vcType + '.', null, false, 6, null);
        }
    }
}

