/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.mappings.presentation;

import com.microsoft.did.sdk.credential.service.PresentationResponse;
import com.microsoft.did.sdk.credential.service.models.presentationexchange.CredentialPresentationInputDescriptor;
import com.microsoft.walletlibrary.requests.requirements.GroupRequirement;
import com.microsoft.walletlibrary.requests.requirements.Requirement;
import com.microsoft.walletlibrary.requests.requirements.VerifiedIdRequirement;
import com.microsoft.walletlibrary.util.IdInVerifiedIdRequirementDoesNotMatchRequestException;
import com.microsoft.walletlibrary.util.UnSupportedRequirementException;
import com.microsoft.walletlibrary.util.VerifiedIdRequirementIdConflictException;
import com.microsoft.walletlibrary.util.VerifiedIdRequirementMissingIdException;
import com.microsoft.walletlibrary.util.VerifiedIdRequirementNotFulfilledException;
import com.microsoft.walletlibrary.verifiedid.VerifiableCredential;
import com.microsoft.walletlibrary.verifiedid.VerifiedId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"addGroupRequirement", "", "Lcom/microsoft/did/sdk/credential/service/PresentationResponse;", "groupRequirement", "Lcom/microsoft/walletlibrary/requests/requirements/GroupRequirement;", "addRequirements", "requirement", "Lcom/microsoft/walletlibrary/requests/requirements/Requirement;", "addVerifiedIdRequirement", "verifiedIdRequirement", "Lcom/microsoft/walletlibrary/requests/requirements/VerifiedIdRequirement;", "walletlibrary_release"})
public final class PresentationResponseMappingKt {
    public static final void addRequirements(@NotNull PresentationResponse $this$addRequirements, @NotNull Requirement requirement) {
        Intrinsics.checkNotNullParameter((Object)$this$addRequirements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        Requirement requirement2 = requirement;
        if (requirement2 instanceof GroupRequirement) {
            PresentationResponseMappingKt.addGroupRequirement($this$addRequirements, (GroupRequirement)requirement);
        } else if (requirement2 instanceof VerifiedIdRequirement) {
            PresentationResponseMappingKt.addVerifiedIdRequirement($this$addRequirements, (VerifiedIdRequirement)requirement);
        } else {
            throw new UnSupportedRequirementException("Requirement type " + Reflection.getOrCreateKotlinClass(requirement.getClass()).getSimpleName() + " is not unsupported.", null, false, 6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addVerifiedIdRequirement(PresentationResponse $this$addVerifiedIdRequirement, VerifiedIdRequirement verifiedIdRequirement) {
        void $this$filterTo$iv$iv;
        if (verifiedIdRequirement.getId$walletlibrary_release() == null) {
            throw new VerifiedIdRequirementMissingIdException("Id is missing in the VerifiedId Requirement.", null, false, 6, null);
        }
        if (verifiedIdRequirement.getVerifiedId$walletlibrary_release() == null) {
            throw new VerifiedIdRequirementNotFulfilledException("Verified Id is not selected to fulfill the requirement.", null, false, 6, null);
        }
        Iterable $this$filter$iv = $this$addVerifiedIdRequirement.getRequest().getPresentationDefinition().getCredentialPresentationInputDescriptors();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CredentialPresentationInputDescriptor it = (CredentialPresentationInputDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)verifiedIdRequirement.getId$walletlibrary_release())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List credentialPresentationInputDescriptor = (List)destination$iv$iv;
        if (credentialPresentationInputDescriptor.isEmpty()) {
            throw new IdInVerifiedIdRequirementDoesNotMatchRequestException("Id in VerifiedId Requirement does not match the id in request.", null, false, 6, null);
        }
        if (credentialPresentationInputDescriptor.size() > 1) {
            throw new VerifiedIdRequirementIdConflictException("Multiple VerifiedId Requirements have the same Ids.", null, false, 6, null);
        }
        Map<CredentialPresentationInputDescriptor, com.microsoft.did.sdk.credential.models.VerifiableCredential> map = verifiedIdRequirement.validate-d1pmJ48();
        ResultKt.throwOnFailure((Object)map);
        map = $this$addVerifiedIdRequirement.getRequestedVcPresentationSubmissionMap();
        Object object2 = CollectionsKt.first((List)credentialPresentationInputDescriptor);
        VerifiedId verifiedId = verifiedIdRequirement.getVerifiedId$walletlibrary_release();
        Intrinsics.checkNotNull((Object)verifiedId, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.verifiedid.VerifiableCredential");
        object = ((VerifiableCredential)verifiedId).getRaw$walletlibrary_release();
        map.put((CredentialPresentationInputDescriptor)object2, (com.microsoft.did.sdk.credential.models.VerifiableCredential)object);
    }

    private static final void addGroupRequirement(PresentationResponse $this$addGroupRequirement, GroupRequirement groupRequirement) {
        Object object = groupRequirement.validate-d1pmJ48();
        ResultKt.throwOnFailure((Object)object);
        List<Requirement> requirements = groupRequirement.getRequirements();
        for (Requirement requirement : requirements) {
            PresentationResponseMappingKt.addRequirements($this$addGroupRequirement, requirement);
        }
    }
}

