/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.microsoft.did.sdk.VerifiableCredentialSdk;
import com.microsoft.walletlibrary.VerifiedIdClient;
import com.microsoft.walletlibrary.VerifiedIdClientBuilder;
import com.microsoft.walletlibrary.requests.RequestHandlerFactory;
import com.microsoft.walletlibrary.requests.RequestResolverFactory;
import com.microsoft.walletlibrary.requests.handlers.OpenIdRequestHandler;
import com.microsoft.walletlibrary.requests.handlers.RequestHandler;
import com.microsoft.walletlibrary.requests.resolvers.OpenIdURLRequestResolver;
import com.microsoft.walletlibrary.requests.resolvers.RequestResolver;
import com.microsoft.walletlibrary.util.WalletLibraryLogger;
import com.microsoft.walletlibrary.util.WalletLibraryVCSDKLogConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/microsoft/walletlibrary/VerifiedIdClientBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "jsonSerializer", "Lkotlinx/serialization/json/Json;", "logger", "Lcom/microsoft/walletlibrary/util/WalletLibraryLogger;", "requestHandlers", "", "Lcom/microsoft/walletlibrary/requests/handlers/RequestHandler;", "requestResolvers", "Lcom/microsoft/walletlibrary/requests/resolvers/RequestResolver;", "build", "Lcom/microsoft/walletlibrary/VerifiedIdClient;", "getUserAgent", "", "applicationContext", "getWalletLibraryVersionInfo", "registerRequestHandler", "", "requestHandler", "registerRequestResolver", "requestResolver", "with", "logConsumer", "Lcom/microsoft/walletlibrary/util/WalletLibraryLogger$Consumer;", "walletlibrary_release"})
public final class VerifiedIdClientBuilder {
    @NotNull
    private final Context context;
    @NotNull
    private WalletLibraryLogger logger;
    @NotNull
    private final List<RequestResolver> requestResolvers;
    @NotNull
    private final List<RequestHandler> requestHandlers;
    @NotNull
    private final Json jsonSerializer;

    public VerifiedIdClientBuilder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.logger = WalletLibraryLogger.INSTANCE;
        this.requestResolvers = new ArrayList();
        this.requestHandlers = new ArrayList();
        this.jsonSerializer = JsonKt.Json$default(null, (Function1)jsonSerializer.1.INSTANCE, (int)1, null);
    }

    public final void with(@NotNull WalletLibraryLogger.Consumer logConsumer) {
        Intrinsics.checkNotNullParameter((Object)logConsumer, (String)"logConsumer");
        this.logger.addConsumer(logConsumer);
    }

    @NotNull
    public final VerifiedIdClient build() {
        RequestResolverFactory requestResolverFactory = new RequestResolverFactory();
        this.registerRequestResolver(new OpenIdURLRequestResolver());
        requestResolverFactory.getRequestResolvers$walletlibrary_release().addAll((Collection<RequestResolver>)this.requestResolvers);
        RequestHandlerFactory requestHandlerFactory = new RequestHandlerFactory();
        this.registerRequestHandler(new OpenIdRequestHandler());
        requestHandlerFactory.getRequestHandlers$walletlibrary_release().addAll((Collection<RequestHandler>)this.requestHandlers);
        WalletLibraryVCSDKLogConsumer vcSdkLogConsumer = new WalletLibraryVCSDKLogConsumer(this.logger);
        Context context = this.context;
        String string = this.getUserAgent(this.context);
        String string2 = this.getWalletLibraryVersionInfo();
        VerifiableCredentialSdk.init$walletlibrary_release$default(context, string, vcSdkLogConsumer, null, null, null, string2, 56, null);
        return new VerifiedIdClient(requestResolverFactory, requestHandlerFactory, this.logger, this.jsonSerializer);
    }

    private final void registerRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    private final void registerRequestResolver(RequestResolver requestResolver) {
        this.requestResolvers.add(requestResolver);
    }

    private final String getWalletLibraryVersionInfo() {
        return "Android/1.0.0";
    }

    private final String getUserAgent(Context applicationContext) {
        String string;
        try {
            PackageManager packageManager = applicationContext.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(applicationContext.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"packageManager.getApplic\u2026onContext.packageName, 0)");
            ApplicationInfo applicationInfo2 = applicationInfo;
            String appName = ((Object)packageManager.getApplicationLabel(applicationInfo2)).toString();
            PackageInfo packageInfo = packageManager.getPackageInfo(applicationContext.getPackageName(), 0);
            string = appName + '/' + packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            WalletLibraryLogger.e$default(WalletLibraryLogger.INSTANCE, "Error getting version name.", e, null, 4, null);
            string = "";
        }
        return string;
    }
}

