/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.microsoft.did.sdk.util.log.SdkLog;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\t"}, d2={"Lcom/microsoft/did/sdk/util/ImageUtil;", "", "()V", "convert", "", "bitmap", "Landroid/graphics/Bitmap;", "parse", "base64Str", "walletlibrary_release"})
public final class ImageUtil {
    @NotNull
    public static final ImageUtil INSTANCE = new ImageUtil();

    private ImageUtil() {
    }

    @Nullable
    public final Bitmap parse(@Nullable String base64Str) {
        CharSequence charSequence = base64Str;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            byte[] decodedBytes = Base64.decode((String)base64Str, (int)11);
            charSequence = BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
        }
        catch (Exception ex) {
            SdkLog.d$default(SdkLog.INSTANCE, "Image couldn't be converted from Base64", ex, null, 4, null);
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public final String convert(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        return Base64.encodeToString((byte[])outputStream.toByteArray(), (int)11);
    }
}

