/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.identifier;

import com.microsoft.did.sdk.identifier.SideTreeHelper;
import com.microsoft.did.sdk.identifier.models.identifierdocument.LinkedDataKeySpecification;
import com.microsoft.did.sdk.identifier.models.payload.IdentifierDocumentPatch;
import com.microsoft.did.sdk.identifier.models.payload.PatchData;
import com.microsoft.did.sdk.identifier.models.payload.RegistrationPayload;
import com.microsoft.did.sdk.identifier.models.payload.SuffixData;
import com.microsoft.did.sdk.identifier.models.payload.document.IdentifierDocumentPayload;
import com.microsoft.did.sdk.identifier.models.payload.document.IdentifierDocumentPublicKeyInput;
import com.nimbusds.jose.jwk.JWK;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/microsoft/did/sdk/identifier/SidetreePayloadProcessor;", "", "sideTreeHelper", "Lcom/microsoft/did/sdk/identifier/SideTreeHelper;", "serializer", "Lkotlinx/serialization/json/Json;", "(Lcom/microsoft/did/sdk/identifier/SideTreeHelper;Lkotlinx/serialization/json/Json;)V", "createDocumentPayload", "Lcom/microsoft/did/sdk/identifier/models/payload/document/IdentifierDocumentPayload;", "signingPublicKey", "Lcom/nimbusds/jose/jwk/JWK;", "createIdentifierDocumentPatch", "Lcom/microsoft/did/sdk/identifier/models/payload/IdentifierDocumentPatch;", "createPatchData", "Lcom/microsoft/did/sdk/identifier/models/payload/PatchData;", "identifierDocumentPatch", "updatePublicKey", "createSuffixData", "Lcom/microsoft/did/sdk/identifier/models/payload/SuffixData;", "patchData", "recoveryKey", "generateCreatePayload", "Lcom/microsoft/did/sdk/identifier/models/payload/RegistrationPayload;", "recoveryPublicKey", "walletlibrary_release"})
public final class SidetreePayloadProcessor {
    @NotNull
    private final SideTreeHelper sideTreeHelper;
    @NotNull
    private final Json serializer;

    @Inject
    public SidetreePayloadProcessor(@NotNull SideTreeHelper sideTreeHelper, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)sideTreeHelper, (String)"sideTreeHelper");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.sideTreeHelper = sideTreeHelper;
        this.serializer = serializer2;
    }

    @NotNull
    public final RegistrationPayload generateCreatePayload(@NotNull JWK signingPublicKey, @NotNull JWK recoveryPublicKey, @NotNull JWK updatePublicKey) {
        Intrinsics.checkNotNullParameter((Object)signingPublicKey, (String)"signingPublicKey");
        Intrinsics.checkNotNullParameter((Object)recoveryPublicKey, (String)"recoveryPublicKey");
        Intrinsics.checkNotNullParameter((Object)updatePublicKey, (String)"updatePublicKey");
        IdentifierDocumentPatch identifierDocumentPatch = this.createIdentifierDocumentPatch(signingPublicKey);
        PatchData patchData = this.createPatchData(identifierDocumentPatch, updatePublicKey);
        SuffixData suffixData = this.createSuffixData(patchData, recoveryPublicKey);
        return new RegistrationPayload(suffixData, patchData);
    }

    private final IdentifierDocumentPayload createDocumentPayload(JWK signingPublicKey) {
        String string = signingPublicKey.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signingPublicKey.keyID");
        return new IdentifierDocumentPayload(CollectionsKt.listOf((Object)new IdentifierDocumentPublicKeyInput(string, (String)CollectionsKt.first(LinkedDataKeySpecification.EcdsaSecp256k1Signature2019.getValues()), null, signingPublicKey, CollectionsKt.listOf((Object)"authentication"), 4, null)), null, 2, null);
    }

    private final IdentifierDocumentPatch createIdentifierDocumentPatch(JWK signingPublicKey) {
        IdentifierDocumentPayload identifierDocumentPayload = this.createDocumentPayload(signingPublicKey);
        return new IdentifierDocumentPatch("replace", identifierDocumentPayload);
    }

    private final PatchData createPatchData(IdentifierDocumentPatch identifierDocumentPatch, JWK updatePublicKey) {
        String updateCommitment = this.sideTreeHelper.createCommitmentValue(updatePublicKey);
        return new PatchData(updateCommitment, CollectionsKt.listOf((Object)identifierDocumentPatch));
    }

    private final SuffixData createSuffixData(PatchData patchData, JWK recoveryKey) {
        String patchDataJson = this.serializer.encodeToString((SerializationStrategy)PatchData.Companion.serializer(), (Object)patchData);
        String patchDataEncoded = this.sideTreeHelper.canonicalizeMultiHashEncode(patchDataJson);
        String recoveryCommitment = this.sideTreeHelper.createCommitmentValue(recoveryKey);
        return new SuffixData(patchDataEncoded, recoveryCommitment);
    }
}

