/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.identifier;

import android.util.Base64;
import com.microsoft.did.sdk.crypto.CryptoOperations;
import com.microsoft.did.sdk.crypto.KeyGenAlgorithm;
import com.microsoft.did.sdk.crypto.MacAlgorithm;
import com.microsoft.did.sdk.crypto.keyStore.ECKeyConverterKt;
import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.identifier.SideTreeHelper;
import com.microsoft.did.sdk.identifier.SidetreePayloadProcessor;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.microsoft.did.sdk.identifier.models.payload.RegistrationPayload;
import com.microsoft.did.sdk.identifier.models.payload.SuffixData;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ(\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0012\u0010\u0018\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fJ\b\u0010\u001e\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/did/sdk/identifier/IdentifierCreator;", "", "payloadProcessor", "Lcom/microsoft/did/sdk/identifier/SidetreePayloadProcessor;", "sideTreeHelper", "Lcom/microsoft/did/sdk/identifier/SideTreeHelper;", "serializer", "Lkotlinx/serialization/json/Json;", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "(Lcom/microsoft/did/sdk/identifier/SidetreePayloadProcessor;Lcom/microsoft/did/sdk/identifier/SideTreeHelper;Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;)V", "computeDidShortFormIdentifier", "", "registrationPayload", "Lcom/microsoft/did/sdk/identifier/models/payload/RegistrationPayload;", "computeLongFormIdentifier", "create", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "personaName", "createIdentifier", "signingPublicKey", "Lcom/nimbusds/jose/jwk/JWK;", "recoveryPublicKey", "updatePublicKey", "generateAndStoreKeyPair", "use", "Lcom/nimbusds/jose/jwk/KeyUse;", "generatePersonaSeed", "", "personaDid", "generateRandomKeyId", "walletlibrary_release"})
public final class IdentifierCreator {
    @NotNull
    private final SidetreePayloadProcessor payloadProcessor;
    @NotNull
    private final SideTreeHelper sideTreeHelper;
    @NotNull
    private final Json serializer;
    @NotNull
    private final EncryptedKeyStore keyStore;

    @Inject
    public IdentifierCreator(@NotNull SidetreePayloadProcessor payloadProcessor, @NotNull SideTreeHelper sideTreeHelper, @NotNull Json serializer2, @NotNull EncryptedKeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)payloadProcessor, (String)"payloadProcessor");
        Intrinsics.checkNotNullParameter((Object)sideTreeHelper, (String)"sideTreeHelper");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.payloadProcessor = payloadProcessor;
        this.sideTreeHelper = sideTreeHelper;
        this.serializer = serializer2;
        this.keyStore = keyStore;
    }

    @NotNull
    public final Identifier create(@NotNull String personaName) {
        Intrinsics.checkNotNullParameter((Object)personaName, (String)"personaName");
        JWK signingPublicKeyJwk = IdentifierCreator.generateAndStoreKeyPair$default(this, null, 1, null);
        JWK recoveryPublicKeyJwk = IdentifierCreator.generateAndStoreKeyPair$default(this, null, 1, null);
        JWK updatePublicKeyJwk = IdentifierCreator.generateAndStoreKeyPair$default(this, null, 1, null);
        return this.createIdentifier(personaName, signingPublicKeyJwk, recoveryPublicKeyJwk, updatePublicKeyJwk);
    }

    private final Identifier createIdentifier(String personaName, JWK signingPublicKey, JWK recoveryPublicKey, JWK updatePublicKey) {
        RegistrationPayload registrationPayload = this.payloadProcessor.generateCreatePayload(signingPublicKey, recoveryPublicKey, updatePublicKey);
        String identifierLongForm = this.computeLongFormIdentifier(registrationPayload);
        String string = signingPublicKey.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signingPublicKey.keyID");
        String string2 = recoveryPublicKey.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"recoveryPublicKey.keyID");
        String string3 = updatePublicKey.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"updatePublicKey.keyID");
        return new Identifier(identifierLongForm, string, "", string2, string3, personaName);
    }

    private final JWK generateAndStoreKeyPair(KeyUse use) {
        String keyId = this.generateRandomKeyId();
        JWK privateKey = ECKeyConverterKt.toPrivateJwk(CryptoOperations.INSTANCE.generateKeyPair(KeyGenAlgorithm.Secp256k1.INSTANCE), keyId, use);
        this.keyStore.storeKey(keyId, privateKey);
        JWK jWK = privateKey.toPublicJWK();
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"privateKey.toPublicJWK()");
        return jWK;
    }

    static /* synthetic */ JWK generateAndStoreKeyPair$default(IdentifierCreator identifierCreator, KeyUse keyUse, int n, Object object) {
        if ((n & 1) != 0) {
            KeyUse keyUse2 = KeyUse.SIGNATURE;
            Intrinsics.checkNotNullExpressionValue((Object)keyUse2, (String)"SIGNATURE");
            keyUse = keyUse2;
        }
        return identifierCreator.generateAndStoreKeyPair(keyUse);
    }

    @NotNull
    public final byte[] generatePersonaSeed(@NotNull String personaDid) {
        Intrinsics.checkNotNullParameter((Object)personaDid, (String)"personaDid");
        byte[] masterSeed = this.keyStore.getKey("did.main.identifier").toOctetSequenceKey().toByteArray();
        String string = personaDid;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return CryptoOperations.INSTANCE.computeMac(byArray, new SecretKeySpec(masterSeed, "AES"), MacAlgorithm.HmacSha512.INSTANCE);
    }

    private final String generateRandomKeyId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final String computeDidShortFormIdentifier(RegistrationPayload registrationPayload) {
        String suffixDataString = this.serializer.encodeToString((SerializationStrategy)SuffixData.Companion.serializer(), (Object)registrationPayload.getSuffixData());
        String uniqueSuffix = this.sideTreeHelper.canonicalizeMultiHashEncode(suffixDataString);
        return "did:ion:" + uniqueSuffix;
    }

    private final String computeLongFormIdentifier(RegistrationPayload registrationPayload) {
        String registrationPayloadString = this.serializer.encodeToString((SerializationStrategy)RegistrationPayload.Companion.serializer(), (Object)registrationPayload);
        byte[] registrationPayloadCanonicalized = new JsonCanonicalizer(registrationPayloadString).getEncodedUTF8();
        String registrationPayloadCanonicalizedEncoded = Base64.encodeToString((byte[])registrationPayloadCanonicalized, (int)11);
        String identifierShortForm = this.computeDidShortFormIdentifier(registrationPayload);
        return identifierShortForm + ':' + registrationPayloadCanonicalizedEncoded;
    }
}

