/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.network.credentialOperations;

import com.microsoft.did.sdk.credential.service.models.oidc.PresentationRequestContent;
import com.microsoft.did.sdk.credential.service.validators.JwtValidator;
import com.microsoft.did.sdk.crypto.protocols.jose.jws.JwsToken;
import com.microsoft.did.sdk.datasource.network.GetNetworkOperation;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.datasource.network.credentialOperations.FetchPresentationRequestNetworkOperation;
import com.microsoft.did.sdk.util.controlflow.DidInHeaderAndPayloadNotMatching;
import com.microsoft.did.sdk.util.controlflow.ExpiredTokenException;
import com.microsoft.did.sdk.util.controlflow.InvalidSignatureException;
import com.microsoft.did.sdk.util.controlflow.NotFoundException;
import com.microsoft.did.sdk.util.controlflow.PresentationException;
import com.microsoft.did.sdk.util.controlflow.Result;
import com.microsoft.did.sdk.util.controlflow.SdkException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J%\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u001b\u001a\u00020\u0002H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\f\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\rX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lcom/microsoft/did/sdk/datasource/network/credentialOperations/FetchPresentationRequestNetworkOperation;", "Lcom/microsoft/did/sdk/datasource/network/GetNetworkOperation;", "", "Lcom/microsoft/did/sdk/credential/service/models/oidc/PresentationRequestContent;", "url", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "jwtValidator", "Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;", "serializer", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/String;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;Lkotlinx/serialization/json/Json;)V", "call", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lretrofit2/Response;", "", "getCall", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "onFailure", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "", "response", "onSuccess", "(Lretrofit2/Response;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyAndUnwrapPresentationRequest", "jwsTokenString", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public final class FetchPresentationRequestNetworkOperation
extends GetNetworkOperation<String, PresentationRequestContent> {
    @NotNull
    private final String url;
    @NotNull
    private final ApiProvider apiProvider;
    @NotNull
    private final JwtValidator jwtValidator;
    @NotNull
    private final Json serializer;
    @NotNull
    private final Function1<Continuation<? super Response<String>>, Object> call;

    public FetchPresentationRequestNetworkOperation(@NotNull String url, @NotNull ApiProvider apiProvider, @NotNull JwtValidator jwtValidator, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)jwtValidator, (String)"jwtValidator");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.url = url;
        this.apiProvider = apiProvider;
        this.jwtValidator = jwtValidator;
        this.serializer = serializer2;
        this.call = (Function1)new Function1<Continuation<? super Response<String>>, Object>(this, null){
            int label;
            final /* synthetic */ FetchPresentationRequestNetworkOperation this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FetchPresentationRequestNetworkOperation.access$getApiProvider$p(this.this$0).getPresentationApis().getRequest(FetchPresentationRequestNetworkOperation.access$getUrl$p(this.this$0), (Continuation<? super Response<String>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<String>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @Override
    @NotNull
    public Function1<Continuation<? super Response<String>>, Object> getCall() {
        return this.call;
    }

    @Override
    @Nullable
    public Object onSuccess(@NotNull Response<String> response, @NotNull Continuation<? super Result<PresentationRequestContent>> $completion) {
        String string = (String)response.body();
        if (string == null) {
            throw new PresentationException("No Presentation Request in Body.", null, false, 6, null);
        }
        String jwsTokenString = string;
        return this.verifyAndUnwrapPresentationRequest(jwsTokenString, $completion);
    }

    @Override
    @NotNull
    public Result onFailure(@NotNull Response<String> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Result result = super.onFailure(response);
        Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type com.microsoft.did.sdk.util.controlflow.Result.Failure");
        SdkException exception = ((Result.Failure)result).getPayload();
        if (exception instanceof NotFoundException) {
            ExpiredTokenException expiredTokenException;
            ExpiredTokenException expiredTokenException2;
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            ExpiredTokenException $this$onFailure_u24lambda_u2d0 = expiredTokenException2 = (expiredTokenException = new ExpiredTokenException(string, false));
            boolean bl = false;
            $this$onFailure_u24lambda_u2d0.setCorrelationVector(((NotFoundException)exception).getCorrelationVector());
            $this$onFailure_u24lambda_u2d0.setErrorBody(((NotFoundException)exception).getErrorBody());
            $this$onFailure_u24lambda_u2d0.setErrorCode(((NotFoundException)exception).getErrorCode());
            $this$onFailure_u24lambda_u2d0.setInnerErrorCodes(((NotFoundException)exception).getInnerErrorCodes());
            return new Result.Failure(expiredTokenException);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private final Object verifyAndUnwrapPresentationRequest(String var1_1, Continuation<? super Result<PresentationRequestContent>> var2_2) {
        if (!(var2_2 instanceof verifyAndUnwrapPresentationRequest.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FetchPresentationRequestNetworkOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FetchPresentationRequestNetworkOperation.access$verifyAndUnwrapPresentationRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                jwsToken = JwsToken.Companion.deserialize((String)jwsTokenString);
                presentationRequestContent = (PresentationRequestContent)this.serializer.decodeFromString((DeserializationStrategy)PresentationRequestContent.Companion.serializer(), jwsToken.content());
                $continuation.L$0 = this;
                $continuation.L$1 = jwsToken;
                $continuation.L$2 = presentationRequestContent;
                $continuation.label = 1;
                v0 = this.jwtValidator.verifySignature(jwsToken, (Continuation<? super Boolean>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                presentationRequestContent = (PresentationRequestContent)$continuation.L$2;
                jwsToken = (JwsToken)$continuation.L$1;
                this = (FetchPresentationRequestNetworkOperation)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    throw new InvalidSignatureException("Signature is not valid on Presentation Request.");
                }
                if (!this.jwtValidator.validateDidInHeaderAndPayload(jwsToken, presentationRequestContent.getClientId())) {
                    throw new DidInHeaderAndPayloadNotMatching("DID used to sign the presentation request doesn't match the DID in presentation request.");
                }
                return new Result.Success<PresentationRequestContent>(presentationRequestContent);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$verifyAndUnwrapPresentationRequest(FetchPresentationRequestNetworkOperation $this, String jwsTokenString, Continuation $completion) {
        return $this.verifyAndUnwrapPresentationRequest(jwsTokenString, (Continuation<? super Result<PresentationRequestContent>>)$completion);
    }

    public static final /* synthetic */ ApiProvider access$getApiProvider$p(FetchPresentationRequestNetworkOperation $this) {
        return $this.apiProvider;
    }

    public static final /* synthetic */ String access$getUrl$p(FetchPresentationRequestNetworkOperation $this) {
        return $this.url;
    }
}

