/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.network;

import com.microsoft.did.sdk.datasource.network.BaseNetworkOperation;
import com.microsoft.did.sdk.util.NetworkErrorParser;
import com.microsoft.did.sdk.util.controlflow.ClientException;
import com.microsoft.did.sdk.util.controlflow.ForbiddenException;
import com.microsoft.did.sdk.util.controlflow.LocalNetworkException;
import com.microsoft.did.sdk.util.controlflow.NetworkException;
import com.microsoft.did.sdk.util.controlflow.NotFoundException;
import com.microsoft.did.sdk.util.controlflow.RedirectException;
import com.microsoft.did.sdk.util.controlflow.Result;
import com.microsoft.did.sdk.util.controlflow.ServiceUnreachableException;
import com.microsoft.did.sdk.util.controlflow.UnauthorizedException;
import com.microsoft.did.sdk.util.log.SdkLog;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\f\"\u0004\b\u0002\u0010\u0001J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R1\u0010\u0005\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u00a6\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/microsoft/did/sdk/datasource/network/BaseNetworkOperation;", "S", "T", "", "()V", "call", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lretrofit2/Response;", "getCall", "()Lkotlin/jvm/functions/Function1;", "fire", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onFailure", "", "response", "onRetry", "onSuccess", "(Lretrofit2/Response;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public abstract class BaseNetworkOperation<S, T> {
    @NotNull
    public abstract Function1<Continuation<? super Response<S>>, Object> getCall();

    @Nullable
    public Object fire(@NotNull Continuation<? super Result<? extends T>> $completion) {
        return BaseNetworkOperation.fire$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ Object fire$suspendImpl(BaseNetworkOperation var0, Continuation var1_1) {
        if (!(var1_1 instanceof fire.1)) ** GOTO lbl-1000
        var15_2 = var1_1;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super fire.1>)var1_1){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseNetworkOperation<S, T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseNetworkOperation.fire$suspendImpl(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                name$iv = String.valueOf(Reflection.getOrCreateKotlinClass($this.getClass()).getSimpleName());
                $i$f$logNetworkTime = false;
                start$iv = System.currentTimeMillis();
                $i$a$-logNetworkTime-BaseNetworkOperation$fire$response$1 = false;
                $continuation.L$0 = $this;
                $continuation.L$1 = name$iv;
                $continuation.J$0 = start$iv;
                $continuation.label = 1;
                v0 = $this.getCall().invoke((Object)$continuation);
                ** if (v0 != var16_4) goto lbl25
lbl24:
                // 1 sources

                return var16_4;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                $i$f$logNetworkTime = false;
                $i$a$-logNetworkTime-BaseNetworkOperation$fire$response$1 = false;
                start$iv = $continuation.J$0;
                name$iv = (String)$continuation.L$1;
                $this = (BaseNetworkOperation)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                result$iv = (Response)v0;
                elapsedTime$iv = System.currentTimeMillis() - start$iv;
                v1 = result$iv.raw().request().headers().get("ms-cv");
                if (v1 == null) {
                    v1 = cvRequest$iv = "none";
                }
                if ((v2 = result$iv.raw().headers().get("ms-cv")) == null) {
                    v2 = cvResponse$iv = "none";
                }
                if ((v3 = result$iv.raw().headers().get("request-id")) == null) {
                    v3 = "none";
                }
                requestId$iv = v3;
                var13_15 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv)), TuplesKt.to((Object)"CV_request", (Object)cvRequest$iv), TuplesKt.to((Object)"CV_response", (Object)cvResponse$iv), TuplesKt.to((Object)"request_Id", (Object)requestId$iv), TuplesKt.to((Object)"isSuccessful", (Object)String.valueOf(result$iv.isSuccessful())), TuplesKt.to((Object)"code", (Object)String.valueOf(result$iv.code()))};
                SdkLog.INSTANCE.event("DIDNetworkMetrics", MapsKt.mapOf((Pair[])var13_15));
                response = result$iv;
                if (!response.isSuccessful()) return $this.onFailure(response);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v4 = $this.onSuccess((Response<S>)response, (Continuation<? super Result<? extends T>>)$continuation);
                if (v4 != var16_4) return v4;
                return var16_4;
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                return v4;
            }
        }
        catch (IOException exception) {
            return new Result.Failure(new LocalNetworkException("Failed to send request.", exception));
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object onSuccess(@NotNull Response<S> response, @NotNull Continuation<? super Result<? extends T>> $completion) {
        return BaseNetworkOperation.onSuccess$suspendImpl(this, response, $completion);
    }

    static /* synthetic */ Object onSuccess$suspendImpl(BaseNetworkOperation $this, Response response, Continuation $completion) {
        Object object = response.body();
        if (object == null) {
            throw new LocalNetworkException("Body of Response is null.", null, 2, null);
        }
        Object transformedPayload = object;
        return new Result.Success<Object>(transformedPayload);
    }

    @NotNull
    public Result onFailure(@NotNull Response<S> response) {
        NetworkException networkException;
        Object responseBody;
        String string;
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Object object = response.errorBody();
        if (object == null || (object = object.string()) == null) {
            object = "";
        }
        if ((string = NetworkErrorParser.INSTANCE.extractErrorMessage((String)(responseBody = object))) == null) {
            string = responseBody;
        }
        String errorMessage = string;
        switch (response.code()) {
            case 301: 
            case 302: 
            case 308: {
                networkException = new RedirectException(errorMessage, false);
                break;
            }
            case 401: {
                networkException = new UnauthorizedException(errorMessage, false);
                break;
            }
            case 400: 
            case 402: {
                networkException = new ClientException(errorMessage, false);
                break;
            }
            case 403: {
                networkException = new ForbiddenException(errorMessage, false);
                break;
            }
            case 404: {
                networkException = new NotFoundException(errorMessage, false);
                break;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: {
                networkException = new ServiceUnreachableException(errorMessage, true);
                break;
            }
            default: {
                networkException = new NetworkException("Unknown Status code", true);
            }
        }
        NetworkException exception = networkException;
        exception.setErrorCode(String.valueOf(response.code()));
        exception.setCorrelationVector(response.headers().get("ms-cv"));
        exception.setRequestId(response.headers().get("request-id"));
        exception.setErrorBody((String)responseBody);
        exception.setInnerErrorCodes(NetworkErrorParser.INSTANCE.extractInnerErrorsCodes(exception.getErrorBody()));
        SdkLog.i$default(SdkLog.INSTANCE, "HttpError: " + exception.getErrorCode() + " body: " + exception.getErrorBody() + " cv: " + exception.getCorrelationVector(), exception, null, 4, null);
        return new Result.Failure(exception);
    }

    @NotNull
    public final <S> Result<S> onRetry() {
        throw new LocalNetworkException("Retry Not Supported.", null, 2, null);
    }
}

