/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto.protocols.jose.jws;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyConverter;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import java.security.Key;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0002\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/microsoft/did/sdk/crypto/protocols/jose/jws/JwsToken;", "", "content", "", "jwsAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "([BLcom/nimbusds/jose/JWSAlgorithm;)V", "", "(Ljava/lang/String;Lcom/nimbusds/jose/JWSAlgorithm;)V", "jwsObject", "Lcom/nimbusds/jose/JWSObject;", "(Lcom/nimbusds/jose/JWSObject;)V", "keyId", "getKeyId", "()Ljava/lang/String;", "serialize", "sign", "", "privateKey", "Lcom/nimbusds/jose/jwk/JWK;", "overrideHeaders", "Lcom/nimbusds/jose/JWSHeader;", "verify", "", "publicKeyJWKs", "", "verifyUsingOctetKeyPair", "octetKeyPair", "Lcom/nimbusds/jose/jwk/OctetKeyPair;", "verifyUsingPublicKey", "publicKey", "Ljava/security/PublicKey;", "Companion", "walletlibrary_release"})
public final class JwsToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private JWSObject jwsObject;

    public JwsToken(@NotNull JWSObject jwsObject) {
        Intrinsics.checkNotNullParameter((Object)jwsObject, (String)"jwsObject");
        this.jwsObject = jwsObject;
    }

    @Nullable
    public final String getKeyId() {
        return this.jwsObject.getHeader().getKeyID();
    }

    public JwsToken(@NotNull byte[] content, @NotNull JWSAlgorithm jwsAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)jwsAlgorithm, (String)"jwsAlgorithm");
        this(new JWSObject(new JWSHeader(jwsAlgorithm), new Payload(content)));
    }

    public JwsToken(@NotNull String content, @NotNull JWSAlgorithm jwsAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)jwsAlgorithm, (String)"jwsAlgorithm");
        this(new JWSObject(new JWSHeader(jwsAlgorithm), new Payload(Base64URL.encode((String)content))));
    }

    @NotNull
    public final String serialize() {
        String string = this.jwsObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwsObject.serialize()");
        return string;
    }

    public final void sign(@NotNull JWK privateKey, @Nullable JWSHeader overrideHeaders) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        JWSHeader jWSHeader = overrideHeaders;
        if (jWSHeader != null) {
            JWSHeader headers = jWSHeader;
            boolean bl = false;
            this.jwsObject = new JWSObject(headers, this.jwsObject.getPayload());
        }
        JWSSigner signer = new DefaultJWSSignerFactory().createJWSSigner(privateKey, this.jwsObject.getHeader().getAlgorithm());
        this.jwsObject.sign(signer);
    }

    public static /* synthetic */ void sign$default(JwsToken jwsToken, JWK jWK, JWSHeader jWSHeader, int n, Object object) {
        if ((n & 2) != 0) {
            jWSHeader = null;
        }
        jwsToken.sign(jWK, jWSHeader);
    }

    public final boolean verify(@NotNull List<? extends JWK> publicKeyJWKs) {
        Intrinsics.checkNotNullParameter(publicKeyJWKs, (String)"publicKeyJWKs");
        Iterator<? extends JWK> iterator = publicKeyJWKs.iterator();
        if (iterator.hasNext()) {
            boolean bl;
            JWK key = iterator.next();
            if (Intrinsics.areEqual((Object)key.getKeyType().getValue(), (Object)"OKP")) {
                OctetKeyPair octetKeyPair = key.toOctetKeyPair();
                Intrinsics.checkNotNullExpressionValue((Object)octetKeyPair, (String)"octetKeyPair");
                bl = this.verifyUsingOctetKeyPair(octetKeyPair);
            } else {
                List list = KeyConverter.toJavaKeys((List)CollectionsKt.listOf((Object)key));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toJavaKeys(listOf(key))");
                Object object = CollectionsKt.first((List)list);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.PublicKey");
                PublicKey publicKey = (PublicKey)object;
                bl = this.verifyUsingPublicKey(publicKey);
            }
            return bl;
        }
        return false;
    }

    public static /* synthetic */ boolean verify$default(JwsToken jwsToken, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return jwsToken.verify(list);
    }

    private final boolean verifyUsingPublicKey(PublicKey publicKey) {
        JWSVerifier verifier = new DefaultJWSVerifierFactory().createJWSVerifier(this.jwsObject.getHeader(), (Key)publicKey);
        return this.jwsObject.verify(verifier);
    }

    private final boolean verifyUsingOctetKeyPair(OctetKeyPair octetKeyPair) {
        Ed25519Verifier verifier = new Ed25519Verifier(octetKeyPair);
        return this.jwsObject.verify((JWSVerifier)verifier);
    }

    @NotNull
    public final String content() {
        String string = this.jwsObject.getPayload().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwsObject.payload.toString()");
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/did/sdk/crypto/protocols/jose/jws/JwsToken$Companion;", "", "()V", "deserialize", "Lcom/microsoft/did/sdk/crypto/protocols/jose/jws/JwsToken;", "jws", "", "walletlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JwsToken deserialize(@NotNull String jws) {
            Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
            JWSObject jWSObject = JWSObject.parse((String)jws);
            Intrinsics.checkNotNullExpressionValue((Object)jWSObject, (String)"parse(jws)");
            return new JwsToken(jWSObject);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

