/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto.protocols.jose.jwe;

import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.crypto.protocols.jose.JwaCryptoHelper;
import com.microsoft.did.sdk.util.controlflow.AlgorithmException;
import com.microsoft.did.sdk.util.controlflow.FailedDecryptException;
import com.microsoft.did.sdk.util.controlflow.KeyException;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.PasswordBasedEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.X25519Encrypter;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyConverter;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0015\u001a\u00020\r2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001c\u0010 \u001a\u00020!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010&\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/microsoft/did/sdk/crypto/protocols/jose/jwe/JweToken;", "", "plaintext", "", "algorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "encryption", "Lcom/nimbusds/jose/EncryptionMethod;", "(Ljava/lang/String;Lcom/nimbusds/jose/JWEAlgorithm;Lcom/nimbusds/jose/EncryptionMethod;)V", "jweToken", "Lcom/nimbusds/jose/JWEObject;", "(Lcom/nimbusds/jose/JWEObject;)V", "contentAsByteArray", "", "getContentAsByteArray", "()[B", "contentAsString", "getContentAsString", "()Ljava/lang/String;", "contentType", "getContentType", "decrypt", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "privateKey", "Ljava/security/Key;", "encrypt", "", "publicKey", "Lcom/nimbusds/jose/jwk/JWK;", "overrideHeaders", "Lcom/nimbusds/jose/JWEHeader;", "getDecrypter", "Lcom/nimbusds/jose/JWEDecrypter;", "getDecrypterByKey", "getDecrypterByKeyStore", "getEncrypter", "Lcom/nimbusds/jose/JWEEncrypter;", "getKeyAlgorithm", "serialize", "Companion", "walletlibrary_release"})
public final class JweToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private JWEObject jweToken;
    private static final int SALT_LENGTH = 8;
    private static final int ITERATION_COUNT = 100000;

    private JweToken(JWEObject jweToken) {
        this.jweToken = jweToken;
    }

    @Nullable
    public final String getContentType() {
        return this.jweToken.getHeader().getContentType();
    }

    @NotNull
    public final byte[] getContentAsByteArray() {
        byte[] byArray = this.jweToken.getPayload().toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.jweToken.payload.toBytes()");
        return byArray;
    }

    @NotNull
    public final String getContentAsString() {
        String string = this.jweToken.getPayload().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.jweToken.payload.toString()");
        return string;
    }

    public JweToken(@NotNull String plaintext, @NotNull JWEAlgorithm algorithm, @NotNull EncryptionMethod encryption) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        this(new JWEObject(new JWEHeader(algorithm, encryption), new Payload(plaintext)));
    }

    public /* synthetic */ JweToken(String string, JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            JWEAlgorithm jWEAlgorithm2 = JWEAlgorithm.ECDH_ES_A256KW;
            Intrinsics.checkNotNullExpressionValue((Object)jWEAlgorithm2, (String)"ECDH_ES_A256KW");
            jWEAlgorithm = jWEAlgorithm2;
        }
        if ((n & 4) != 0) {
            EncryptionMethod encryptionMethod2 = EncryptionMethod.A256CBC_HS512;
            Intrinsics.checkNotNullExpressionValue((Object)encryptionMethod2, (String)"A256CBC_HS512");
            encryptionMethod = encryptionMethod2;
        }
        this(string, jWEAlgorithm, encryptionMethod);
    }

    @NotNull
    public final JWEAlgorithm getKeyAlgorithm() {
        JWEAlgorithm jWEAlgorithm = this.jweToken.getHeader().getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)jWEAlgorithm, (String)"jweToken.header.algorithm");
        return jWEAlgorithm;
    }

    public final void encrypt(@NotNull JWK publicKey, @Nullable JWEHeader overrideHeaders) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        JWEEncrypter encrypter = this.getEncrypter(publicKey);
        JWEHeader jWEHeader = overrideHeaders;
        if (jWEHeader != null) {
            JWEHeader headers = jWEHeader;
            boolean bl = false;
            this.jweToken = new JWEObject(headers, this.jweToken.getPayload());
        }
        this.jweToken.encrypt(encrypter);
    }

    public static /* synthetic */ void encrypt$default(JweToken jweToken, JWK jWK, JWEHeader jWEHeader, int n, Object object) {
        if ((n & 2) != 0) {
            jWEHeader = null;
        }
        jweToken.encrypt(jWK, jWEHeader);
    }

    private final JWEEncrypter getEncrypter(JWK publicKey) {
        JWEEncrypter jWEEncrypter;
        JWK jWK = publicKey;
        if (jWK instanceof ECKey) {
            jWEEncrypter = (JWEEncrypter)new ECDHEncrypter((ECKey)publicKey);
        } else if (jWK instanceof RSAKey) {
            jWEEncrypter = (JWEEncrypter)new RSAEncrypter((RSAKey)publicKey);
        } else if (jWK instanceof OctetKeyPair) {
            jWEEncrypter = (JWEEncrypter)new X25519Encrypter((OctetKeyPair)publicKey);
        } else if (jWK instanceof OctetSequenceKey) {
            jWEEncrypter = (JWEEncrypter)new PasswordBasedEncrypter(((OctetSequenceKey)publicKey).getKeyValue().decode(), 8, 100000);
        } else {
            throw new AlgorithmException("Unknown public key type " + Reflection.getOrCreateKotlinClass(publicKey.getClass()).getQualifiedName(), null, 2, null);
        }
        return jWEEncrypter;
    }

    @NotNull
    public final String serialize() {
        String string = this.jweToken.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jweToken.serialize()");
        return string;
    }

    @NotNull
    public final byte[] decrypt(@Nullable EncryptedKeyStore keyStore, @Nullable Key privateKey) {
        if (this.jweToken.getState() == JWEObject.State.DECRYPTED || this.jweToken.getState() == JWEObject.State.UNENCRYPTED) {
            byte[] byArray = this.jweToken.getPayload().toBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jweToken.payload.toBytes()");
            return byArray;
        }
        JWEDecrypter decrypter = this.getDecrypter(keyStore, privateKey);
        try {
            this.jweToken.decrypt(decrypter);
        }
        catch (JOSEException exception) {
            throw new FailedDecryptException("Failed to decrypt", exception, false, 4, null);
        }
        byte[] byArray = this.jweToken.getPayload().toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jweToken.payload.toBytes()");
        return byArray;
    }

    public static /* synthetic */ byte[] decrypt$default(JweToken jweToken, EncryptedKeyStore encryptedKeyStore, Key key, int n, Object object) {
        if ((n & 1) != 0) {
            encryptedKeyStore = null;
        }
        if ((n & 2) != 0) {
            key = null;
        }
        return jweToken.decrypt(encryptedKeyStore, key);
    }

    private final JWEDecrypter getDecrypter(EncryptedKeyStore keyStore, Key privateKey) {
        Key key;
        block8: {
            Object object;
            block7: {
                if (keyStore == null && privateKey == null) {
                    throw new IllegalArgumentException("keyStore or privateKey must be passed as input");
                }
                key = privateKey;
                if (key == null) break block7;
                Key it = key;
                boolean bl = false;
                JWEDecrypter jWEDecrypter = this.getDecrypterByKey(it);
                key = jWEDecrypter;
                if (jWEDecrypter != null) break block8;
            }
            EncryptedKeyStore encryptedKeyStore = keyStore;
            if (encryptedKeyStore != null) {
                EncryptedKeyStore it = encryptedKeyStore;
                boolean bl = false;
                object = this.getDecrypterByKeyStore(it);
            } else {
                object = key = null;
            }
            if (object == null) {
                throw new KeyException("No key found", null, 2, null);
            }
        }
        return key;
    }

    private final JWEDecrypter getDecrypterByKey(Key privateKey) {
        JWEDecrypter jWEDecrypter;
        try {
            jWEDecrypter = new DefaultJWEDecrypterFactory().createJWEDecrypter(this.jweToken.getHeader(), privateKey);
        }
        catch (JOSEException exception) {
            jWEDecrypter = null;
        }
        return jWEDecrypter;
    }

    private final JWEDecrypter getDecrypterByKeyStore(EncryptedKeyStore keyStore) {
        JWEDecrypter jWEDecrypter;
        String string = this.jweToken.getHeader().getKeyID();
        if (string != null) {
            String keyId = string;
            boolean bl = false;
            String keyRef = (String)JwaCryptoHelper.INSTANCE.extractDidAndKeyRef(keyId).getSecond();
            JWK key = keyStore.getKey(keyRef);
            DefaultJWEDecrypterFactory defaultJWEDecrypterFactory = new DefaultJWEDecrypterFactory();
            JWEHeader jWEHeader = this.jweToken.getHeader();
            List list = KeyConverter.toJavaKeys((List)CollectionsKt.listOf((Object)key));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toJavaKeys(listOf(key))");
            jWEDecrypter = defaultJWEDecrypterFactory.createJWEDecrypter(jWEHeader, (Key)CollectionsKt.last((List)list));
        } else {
            jWEDecrypter = null;
        }
        return jWEDecrypter;
    }

    public /* synthetic */ JweToken(JWEObject jweToken, DefaultConstructorMarker $constructor_marker) {
        this(jweToken);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/did/sdk/crypto/protocols/jose/jwe/JweToken$Companion;", "", "()V", "ITERATION_COUNT", "", "SALT_LENGTH", "deserialize", "Lcom/microsoft/did/sdk/crypto/protocols/jose/jwe/JweToken;", "jwe", "", "walletlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JweToken deserialize(@NotNull String jwe) {
            Intrinsics.checkNotNullParameter((Object)jwe, (String)"jwe");
            JWEObject jWEObject = JWEObject.parse((String)jwe);
            Intrinsics.checkNotNullExpressionValue((Object)jWEObject, (String)"parse(jwe)");
            return new JweToken(jWEObject, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

