/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto.protocols.jose;

import com.microsoft.did.sdk.util.controlflow.ValidatorException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J \u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/microsoft/did/sdk/crypto/protocols/jose/JwaCryptoHelper;", "", "()V", "extractDidAndKeyId", "Lkotlin/Pair;", "", "keyId", "extractDidAndKeyRef", "matchDidAndKeyId", "walletlibrary_release"})
public final class JwaCryptoHelper {
    @NotNull
    public static final JwaCryptoHelper INSTANCE = new JwaCryptoHelper();

    private JwaCryptoHelper() {
    }

    @NotNull
    public final Pair<String, String> extractDidAndKeyId(@NotNull String keyId) {
        Pair<String, String> match;
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Pair<String, String> pair = match = this.matchDidAndKeyId(keyId);
        if (pair == null) {
            throw new ValidatorException("JWS contains no key id", null, false, 6, null);
        }
        return pair;
    }

    @NotNull
    public final Pair<String, String> extractDidAndKeyRef(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Pair match = this.matchDidAndKeyId(keyId);
        Pair pair = match;
        if (pair == null) {
            pair = new Pair(null, (Object)keyId);
        }
        return pair;
    }

    private final Pair<String, String> matchDidAndKeyId(String keyId) {
        MatchResult matches = new Regex("^([^#]*)#(.+)$").matchEntire((CharSequence)keyId);
        return matches != null ? new Pair((Object)(!StringsKt.isBlank((CharSequence)((CharSequence)matches.getGroupValues().get(1))) ? (String)matches.getGroupValues().get(1) : (String)null), matches.getGroupValues().get(2)) : (Pair)matches;
    }
}

