/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto.keyStore;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.microsoft.did.sdk.util.controlflow.KeyStoreException;
import com.nimbusds.jose.jwk.JWK;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "encryptedSharedPreferences", "Landroid/content/SharedPreferences;", "getEncryptedSharedPreferences", "()Landroid/content/SharedPreferences;", "encryptedSharedPreferences$delegate", "Lkotlin/Lazy;", "containsKey", "", "keyId", "", "getKey", "Lcom/nimbusds/jose/jwk/JWK;", "getSharedPreferences", "storeKey", "", "key", "Companion", "walletlibrary_release"})
public final class EncryptedKeyStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy encryptedSharedPreferences$delegate;
    @NotNull
    private static final String KEY_PREFIX = "DID_KEY_";
    @NotNull
    private static final String FILE_NAME = "DID_encrypted_keys";

    @Inject
    public EncryptedKeyStore(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.encryptedSharedPreferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this, context){
            final /* synthetic */ EncryptedKeyStore this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SharedPreferences invoke() {
                return EncryptedKeyStore.access$getSharedPreferences(this.this$0, this.$context);
            }
        }));
    }

    private final SharedPreferences getEncryptedSharedPreferences() {
        Lazy lazy = this.encryptedSharedPreferences$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        String string = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrCreate(MasterKeys.AES256_GCM_SPEC)");
        String masterKeyAlias = string;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)FILE_NAME, (String)masterKeyAlias, (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            FILE\u2026heme.AES256_GCM\n        )");
        return sharedPreferences;
    }

    public final void storeKey(@NotNull String keyId, @NotNull JWK key) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getEncryptedSharedPreferences().edit().putString(KEY_PREFIX + keyId, key.toJSONString()).apply();
    }

    @NotNull
    public final JWK getKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        String string = this.getEncryptedSharedPreferences().getString(KEY_PREFIX + keyId, null);
        if (string == null) {
            throw new KeyStoreException("Key " + keyId + " not found", null, 2, null);
        }
        String keyJson = string;
        JWK jWK = JWK.parse((String)keyJson);
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"parse(keyJson)");
        return jWK;
    }

    public final boolean containsKey(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        return this.getEncryptedSharedPreferences().contains(KEY_PREFIX + keyId);
    }

    public static final /* synthetic */ SharedPreferences access$getSharedPreferences(EncryptedKeyStore $this, Context context) {
        return $this.getSharedPreferences(context);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore$Companion;", "", "()V", "FILE_NAME", "", "KEY_PREFIX", "walletlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

