/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto;

import com.microsoft.did.sdk.crypto.spi.EcPairwisePrivateKeySpec;
import com.nimbusds.jose.jwk.Curve;
import java.math.BigInteger;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.KeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b \u0018\u00002\u00020\u0001:\u0002\r\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm;", "", "name", "", "provider", "keySpec", "Ljava/security/spec/KeySpec;", "(Ljava/lang/String;Ljava/lang/String;Ljava/security/spec/KeySpec;)V", "getKeySpec", "()Ljava/security/spec/KeySpec;", "getName", "()Ljava/lang/String;", "getProvider", "EcPairwise", "Secp256k1", "walletlibrary_release"})
public abstract class PrivateKeyFactoryAlgorithm {
    @NotNull
    private final String name;
    @Nullable
    private final String provider;
    @NotNull
    private final KeySpec keySpec;

    public PrivateKeyFactoryAlgorithm(@NotNull String name, @Nullable String provider, @NotNull KeySpec keySpec) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        this.name = name;
        this.provider = provider;
        this.keySpec = keySpec;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getProvider() {
        return this.provider;
    }

    @NotNull
    public final KeySpec getKeySpec() {
        return this.keySpec;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm$EcPairwise;", "Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm;", "ecPairwisePrivateKeySpec", "Lcom/microsoft/did/sdk/crypto/spi/EcPairwisePrivateKeySpec;", "(Lcom/microsoft/did/sdk/crypto/spi/EcPairwisePrivateKeySpec;)V", "walletlibrary_release"})
    public static final class EcPairwise
    extends PrivateKeyFactoryAlgorithm {
        public EcPairwise(@NotNull EcPairwisePrivateKeySpec ecPairwisePrivateKeySpec) {
            Intrinsics.checkNotNullParameter((Object)ecPairwisePrivateKeySpec, (String)"ecPairwisePrivateKeySpec");
            super("ecPairwise", "DID", ecPairwisePrivateKeySpec);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm$Secp256k1;", "Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm;", "s", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "walletlibrary_release"})
    public static final class Secp256k1
    extends PrivateKeyFactoryAlgorithm {
        public Secp256k1(@NotNull BigInteger s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            super("EC", null, new ECPrivateKeySpec(s, Curve.SECP256K1.toECParameterSpec()));
        }
    }
}

