/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto;

import com.microsoft.did.sdk.crypto.CipherAlgorithm;
import com.microsoft.did.sdk.crypto.DigestAlgorithm;
import com.microsoft.did.sdk.crypto.KeyGenAlgorithm;
import com.microsoft.did.sdk.crypto.MacAlgorithm;
import com.microsoft.did.sdk.crypto.PrivateKeyFactoryAlgorithm;
import com.microsoft.did.sdk.crypto.PublicKeyFactoryAlgorithm;
import com.microsoft.did.sdk.crypto.SigningAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fJ\"\u0010\u0012\u001a\u0002H\u0013\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u00142\u0006\u0010\b\u001a\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0012\u001a\u0002H\u0013\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u00142\u0006\u0010\b\u001a\u00020\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020 J&\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020 \u00a8\u0006&"}, d2={"Lcom/microsoft/did/sdk/crypto/CryptoOperations;", "", "()V", "computeMac", "", "payload", "key", "Ljavax/crypto/SecretKey;", "alg", "Lcom/microsoft/did/sdk/crypto/MacAlgorithm;", "decrypt", "cipherText", "Lcom/microsoft/did/sdk/crypto/CipherAlgorithm;", "digest", "preImage", "Lcom/microsoft/did/sdk/crypto/DigestAlgorithm;", "encrypt", "plainText", "generateKey", "T", "Ljava/security/Key;", "Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm;", "(Lcom/microsoft/did/sdk/crypto/PrivateKeyFactoryAlgorithm;)Ljava/security/Key;", "Lcom/microsoft/did/sdk/crypto/PublicKeyFactoryAlgorithm;", "(Lcom/microsoft/did/sdk/crypto/PublicKeyFactoryAlgorithm;)Ljava/security/Key;", "generateKeyPair", "Ljava/security/KeyPair;", "Lcom/microsoft/did/sdk/crypto/KeyGenAlgorithm;", "generateSeed", "sign", "signingKey", "Ljava/security/PrivateKey;", "Lcom/microsoft/did/sdk/crypto/SigningAlgorithm;", "verify", "", "signature", "publicKey", "Ljava/security/PublicKey;", "walletlibrary_release"})
public final class CryptoOperations {
    @NotNull
    public static final CryptoOperations INSTANCE = new CryptoOperations();

    private CryptoOperations() {
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] digest, @NotNull PrivateKey signingKey, @NotNull SigningAlgorithm alg) {
        Signature signer;
        Signature signature;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Signature $this$sign_u24lambda_u2d0 = signature = (signer = alg.getProvider() == null ? Signature.getInstance(alg.getName()) : Signature.getInstance(alg.getName(), alg.getProvider()));
        boolean bl = false;
        $this$sign_u24lambda_u2d0.initSign(signingKey);
        $this$sign_u24lambda_u2d0.update(digest);
        if (alg.getSpec() != null) {
            $this$sign_u24lambda_u2d0.setParameter(alg.getSpec());
        }
        byte[] byArray = signer.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signer.sign()");
        return byArray;
    }

    public final boolean verify(@NotNull byte[] digest, @NotNull byte[] signature, @NotNull PublicKey publicKey, @NotNull SigningAlgorithm alg) {
        Signature verifier;
        Signature signature2;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Signature $this$verify_u24lambda_u2d1 = signature2 = (verifier = alg.getProvider() == null ? Signature.getInstance(alg.getName()) : Signature.getInstance(alg.getName(), alg.getProvider()));
        boolean bl = false;
        $this$verify_u24lambda_u2d1.initVerify(publicKey);
        $this$verify_u24lambda_u2d1.update(digest);
        if (alg.getSpec() != null) {
            $this$verify_u24lambda_u2d1.setParameter(alg.getSpec());
        }
        return verifier.verify(signature);
    }

    @NotNull
    public final byte[] digest(@NotNull byte[] preImage, @NotNull DigestAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)preImage, (String)"preImage");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        MessageDigest messageDigest = alg.getProvider() == null ? MessageDigest.getInstance(alg.getName()) : MessageDigest.getInstance(alg.getName(), alg.getProvider());
        byte[] byArray = messageDigest.digest(preImage);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest(preImage)");
        return byArray;
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] plainText, @NotNull SecretKey key, @NotNull CipherAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher cipher = alg.getProvider() == null ? Cipher.getInstance(alg.getName()) : Cipher.getInstance(alg.getName(), alg.getProvider());
        cipher.init(1, key);
        byte[] byArray = cipher.doFinal(plainText);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(plainText)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] cipherText, @NotNull SecretKey key, @NotNull CipherAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher cipher = alg.getProvider() == null ? Cipher.getInstance(alg.getName()) : Cipher.getInstance(alg.getName(), alg.getProvider());
        cipher.init(2, key);
        byte[] byArray = cipher.doFinal(cipherText);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(cipherText)");
        return byArray;
    }

    @NotNull
    public final byte[] computeMac(@NotNull byte[] payload, @NotNull SecretKey key, @NotNull MacAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Mac mac = alg.getProvider() == null ? Mac.getInstance(alg.getName()) : Mac.getInstance(alg.getName(), alg.getProvider());
        mac.init(key);
        byte[] byArray = mac.doFinal(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(payload)");
        return byArray;
    }

    @NotNull
    public final KeyPair generateKeyPair(@NotNull KeyGenAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        KeyPairGenerator keyGen = alg.getProvider() == null ? KeyPairGenerator.getInstance(alg.getName()) : KeyPairGenerator.getInstance(alg.getName(), alg.getProvider());
        keyGen.initialize(alg.getSpec());
        KeyPair keyPair = keyGen.genKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyGen.genKeyPair()");
        return keyPair;
    }

    public final /* synthetic */ <T extends Key> T generateKey(PrivateKeyFactoryAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        boolean $i$f$generateKey = false;
        KeyFactory factory = alg.getProvider() == null ? KeyFactory.getInstance(alg.getName()) : KeyFactory.getInstance(alg.getName(), alg.getProvider());
        PrivateKey privateKey = factory.generatePrivate(alg.getKeySpec());
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)privateKey;
    }

    public final /* synthetic */ <T extends Key> T generateKey(PublicKeyFactoryAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        boolean $i$f$generateKey = false;
        KeyFactory factory = alg.getProvider() == null ? KeyFactory.getInstance(alg.getName()) : KeyFactory.getInstance(alg.getName(), alg.getProvider());
        PublicKey publicKey = factory.generatePublic(alg.getKeySpec());
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)publicKey;
    }

    @NotNull
    public final byte[] generateSeed() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = secureRandom.generateSeed(32);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secureRandom.generateSeed(SEED_BYTES)");
        return byArray;
    }
}

